/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.cohort.CohortFilterView;
import org.ut.biolab.medsavant.client.filter.FieldFilterHolder;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.filter.FilterHolder;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.OntologyFilterHolder;
import org.ut.biolab.medsavant.client.filter.SimpleFilterHolder;
import org.ut.biolab.medsavant.client.filter.TagFilterView;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.region.RegionSetFilterView;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.OntologyType;

public class QueryPanel
extends CollapsiblePanes {
    static final Color INACTIVE_KEY_COLOR = Color.GRAY;
    static final Color ACTIVE_KEY_COLOR = new Color(72, 181, 249);
    private int queryID;
    private Map<String, FilterHolder> filterHolders = new TreeMap<String, FilterHolder>();

    public QueryPanel(int queryID) {
        this.queryID = queryID;
        this.setOpaque(false);
        this.setBorder(null);
        CollapsiblePane p1 = new CollapsiblePane("Search Conditions");
        p1.setBorder(null);
        p1.setStyle(1);
        p1.setCollapsible(false);
        ViewUtil.applyVerticalBoxLayout(p1.getContentPane());
        p1.add((Component)this.populateFilterList());
        this.add((Component)p1);
        this.addExpansion();
        p1.repaint();
    }

    public Collection<FilterHolder> getFilterHolders() {
        return this.filterHolders.values();
    }

    private boolean isFilterable(ColumnType type) {
        switch (type) {
            case INTEGER: 
            case FLOAT: 
            case DECIMAL: 
            case BOOLEAN: 
            case VARCHAR: {
                return true;
            }
        }
        return false;
    }

    private JPanel populateFilterList() {
        CollapsiblePanes panes = new CollapsiblePanes();
        panes.setOpaque(false);
        ViewUtil.applyVerticalBoxLayout((Container)panes);
        panes.setBorder(null);
        try {
            AnnotationFormat[] afs;
            ArrayList<FilterHolder> catHolders = new ArrayList<FilterHolder>();
            catHolders.add(new SimpleFilterHolder(CohortFilterView.class, this.queryID));
            for (CustomField field : ProjectController.getInstance().getCurrentPatientFormat()) {
                if (!field.isFilterable() || !this.isFilterable(field.getColumnType())) continue;
                catHolders.add(new FieldFilterHolder(field, WhichTable.PATIENT, this.queryID));
            }
            panes.add((Component)this.addFilterCategory("Conditions on Individuals", catHolders, false), (Object)"Center");
            for (AnnotationFormat af : afs = ProjectController.getInstance().getCurrentAnnotationFormats()) {
                String name;
                for (CustomField field : af.getCustomFields()) {
                    if (!field.isFilterable() || !this.isFilterable(field.getColumnType())) continue;
                    catHolders.add(new FieldFilterHolder(field, WhichTable.VARIANT, this.queryID));
                }
                if (af.getProgram().equals("VCF")) {
                    catHolders.add(new SimpleFilterHolder(TagFilterView.class, this.queryID));
                }
                if (!(name = af.getProgram()).toLowerCase().contains("conditions")) {
                    name = name + " Conditions";
                }
                panes.add((Component)this.addFilterCategory(ViewUtil.ellipsize(name, 40), catHolders, false), (Object)"Center");
            }
            catHolders.add(new OntologyFilterHolder(OntologyType.GO, this.queryID));
            catHolders.add(new OntologyFilterHolder(OntologyType.HPO, this.queryID));
            catHolders.add(new OntologyFilterHolder(OntologyType.OMIM, this.queryID));
            catHolders.add(new SimpleFilterHolder(RegionSetFilterView.class, this.queryID));
            panes.add((Component)this.addFilterCategory("Ontology and Region Conditions", catHolders, true), (Object)"Center");
            panes.add((Component)this.addFilterCategory("Plugin Conditions", catHolders, false));
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to load search conditions: %s", ex);
        }
        return panes;
    }

    private CollapsiblePane addFilterCategory(String title, List<FilterHolder> catHolders, boolean longRunning) throws PropertyVetoException {
        CollapsiblePane cPane = new CollapsiblePane(title);
        cPane.setCollapsed(true);
        cPane.setOpaque(false);
        cPane.setLayout((LayoutManager)new BorderLayout());
        cPane.setStyle(2);
        KeyValuePairPanel kvp = new KeyValuePairPanel(2);
        cPane.add((Component)kvp, (Object)"Center");
        for (FilterHolder f : catHolders) {
            f.addTo(kvp, longRunning);
        }
        FilterController.getInstance().addListener(new FilterEventListener(cPane, kvp));
        for (FilterHolder h : catHolders) {
            this.filterHolders.put(h.getFilterID(), h);
        }
        catHolders.clear();
        return cPane;
    }

    public void loadFilterView(FilterState state) throws Exception {
        FilterHolder h = this.filterHolders.get(state.getFilterID());
        if (h == null) {
            throw new Exception(String.format("Unknown filter ID \"%s\"", state.getFilterID()));
        }
        h.loadFilterView(state);
        h.openFilterView();
    }

    private class FilterEventListener
    implements Listener<FilterEvent> {
        private final String baseTitle;
        private final CollapsiblePane collapsiblePane;
        private final KeyValuePairPanel keyValuePanel;

        private FilterEventListener(CollapsiblePane cPane, KeyValuePairPanel kvp) {
            this.collapsiblePane = cPane;
            this.keyValuePanel = kvp;
            this.baseTitle = cPane.getTitle();
        }

        @Override
        public void handleEvent(FilterEvent event) {
            Filter changedFilter = event.getFilter();
            if (this.keyValuePanel.containsKey(changedFilter.getName())) {
                JComponent xButton = this.keyValuePanel.getAdditionalColumn(changedFilter.getName(), 0);
                switch (event.getType()) {
                    case ADDED: 
                    case MODIFIED: {
                        this.keyValuePanel.setKeyColour(changedFilter.getName(), ACTIVE_KEY_COLOR);
                        this.collapsiblePane.setTitle(String.format("<html><font color=\"#48B5F9\">%s</font></html>", this.baseTitle));
                        xButton.setVisible(true);
                        break;
                    }
                    case REMOVED: {
                        this.keyValuePanel.setKeyColour(changedFilter.getName(), INACTIVE_KEY_COLOR);
                        this.collapsiblePane.setTitle(this.baseTitle);
                        xButton.setVisible(false);
                    }
                }
            }
        }
    }
}

