/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.GeneticsFilterPage;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;

class SavedFiltersEditor
extends DetailedListEditor {
    SavedFiltersEditor() {
    }

    @Override
    public boolean doesImplementAdding() {
        return false;
    }

    @Override
    public boolean doesImplementDeleting() {
        return true;
    }

    @Override
    public boolean doesImplementLoading() {
        return true;
    }

    @Override
    public void deleteItems(List<Object[]> items) {
        int result;
        if (items.size() == 1) {
            String name = (String)items.get(0)[0];
            result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This cannot be undone.</html>", name);
        } else {
            result = DialogUtils.askYesNo("Confirm", "Are you sure you want to remove these %d filter sets?\nThis cannot be undone.", items.size());
        }
        if (result == 0) {
            for (Object[] row : items) {
                new File(DirectorySettings.getFiltersDirectory(), row[0] + ".xml").delete();
            }
        }
    }

    @Override
    public void loadItems(final List<Object[]> items) {
        if (!FilterController.getInstance().hasFiltersApplied() || DialogUtils.askYesNo("Confirm Load", "<html>Loading filters clears all existing filters. <br>Are you sure you want to continue?</html>") == 0) {
            final JDialog d = new JDialog(MedSavantFrame.getInstance(), "Search Conditions", true);
            WaitPanel p = new WaitPanel("Applying search conditions...");
            d.add(p);
            d.pack();
            d.setLocationRelativeTo(MedSavantFrame.getInstance());
            d.setResizable(false);
            d.setDefaultCloseOperation(0);
            new MedSavantWorker<Boolean>("SavedFiltersPanel"){

                @Override
                protected void showProgress(double fract) {
                }

                @Override
                protected void showSuccess(Boolean success) {
                    d.setVisible(false);
                    if (success.booleanValue()) {
                        DialogUtils.displayMessage("Search conditions applied");
                    } else {
                        DialogUtils.displayError("Error loading search conditions");
                    }
                }

                @Override
                protected Boolean doInBackground() throws Exception {
                    try {
                        ArrayList<File> files = new ArrayList<File>();
                        for (Object[] row : items) {
                            files.add(new File(DirectorySettings.getFiltersDirectory(), row[0] + ".xml"));
                        }
                        GeneticsFilterPage.getSearchBar().loadFiltersFromFiles(files);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return false;
                    }
                    return true;
                }
            }.execute();
            d.setVisible(true);
        }
    }
}

