/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import com.explodingpixels.macwidgets.SourceListControlBar;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommHandler;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommRegistry;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.VariantResultComm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterHistoryPanel;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.QueryPanel;
import org.ut.biolab.medsavant.client.filter.SavedFiltersPanel;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.query.SearchConditionGroupItem;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantConditionViewGenerator;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.variant.ExportVCFWizard;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class SearchBar
extends JPanel {
    private static final String SAVED_SEARCH_EXTENSION = "cond";
    private static SearchBar instance;
    private FilterController controller;
    List<QueryPanel> queryPanels = new ArrayList<QueryPanel>();
    private int nextQueryID = 1;
    private JPanel queryPanelContainer;
    private FilterHistoryPanel historyPanel;
    private QueryViewController queryViewController;
    private final FileNameExtensionFilter filenameFilter = new FileNameExtensionFilter("Saved Searches", "cond");

    private SearchBar() {
        this.controller = FilterController.getInstance();
        this.initComponents();
        this.createNewQueryPanel();
    }

    public static SearchBar getInstance() {
        if (instance == null) {
            instance = new SearchBar();
        }
        return instance;
    }

    public final QueryPanel createNewQueryPanel() {
        QueryPanel cp = new QueryPanel(this.nextQueryID++);
        this.queryPanelContainer.add((Component)((Object)cp));
        this.queryPanels.add(cp);
        this.refreshSubPanels();
        return cp;
    }

    public void refreshSubPanels() {
        this.queryPanelContainer.removeAll();
        for (int i = 0; i < this.queryPanels.size(); ++i) {
            this.queryPanelContainer.add((Component)((Object)this.queryPanels.get(i)));
            this.queryPanelContainer.add(Box.createVerticalStrut(5));
        }
        this.queryPanelContainer.add(Box.createVerticalGlue());
    }

    public void clearAll() {
        this.queryPanels.clear();
        this.nextQueryID = 1;
        this.createNewQueryPanel();
    }

    void loadFiltersFromFiles(Collection<File> files) throws Exception {
        List<List<FilterState>> states = FilterState.loadFiltersFromFiles(files);
        this.controller.removeAllFilters();
        this.queryPanels.clear();
        this.nextQueryID = 1;
        for (int i = 0; i < states.size(); ++i) {
            QueryPanel qp = this.createNewQueryPanel();
            List<FilterState> filters = states.get(i);
            for (FilterState state : filters) {
                qp.loadFilterView(state);
            }
        }
        this.refreshSubPanels();
    }

    private void initComponents() {
        this.setBackground(ViewUtil.getSidebarColor());
        this.setBorder(ViewUtil.getSideLineBorder());
        this.setLayout(new BorderLayout());
        this.queryPanelContainer = ViewUtil.getClearPanel();
        this.queryPanelContainer.setLayout(new BoxLayout(this.queryPanelContainer, 1));
        this.historyPanel = new FilterHistoryPanel();
        Dimension dialogDimensions = new Dimension(400, 400);
        this.historyPanel.setMinimumSize(dialogDimensions);
        this.historyPanel.setPreferredSize(dialogDimensions);
        final JDialog dHistory = new JDialog((Frame)MedSavantFrame.getInstance(), true);
        dHistory.setTitle("Search History");
        dHistory.add(this.historyPanel);
        dHistory.pack();
        dHistory.setLocationRelativeTo(MedSavantFrame.getInstance());
        dHistory.setResizable(false);
        final JFileChooser fileChooser = new JFileChooser();
        JDialog dSave = new JDialog((Frame)MedSavantFrame.getInstance(), true);
        dSave.setTitle("Load Search Conditions");
        dSave.setResizable(false);
        final SourceListControlBar controlbar = new SourceListControlBar();
        controlbar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CLEAR_ON_TOOLBAR), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.askYesNo("Clear current search", "Clear current search?") == 0) {
                    SearchBar.this.getQueryViewController().clearSearch();
                }
            }
        });
        controlbar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.SAVE_ON_TOOLBAR), new ActionListener(){

            private void saveFile(File file) {
                SearchBar.this.getQueryViewController().saveConditions(file);
                JOptionPane.showMessageDialog(MedSavantFrame.getInstance(), "Search conditions saved to " + file.getPath());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooser.setFileFilter(SearchBar.this.filenameFilter);
                if (fileChooser.showSaveDialog(MedSavantFrame.getInstance()) == 0) {
                    File file = fileChooser.getSelectedFile();
                    if (!file.getPath().toLowerCase().endsWith(".cond")) {
                        file = new File(file.getPath() + "." + SearchBar.SAVED_SEARCH_EXTENSION);
                    }
                    if (file.exists()) {
                        int r = JOptionPane.showConfirmDialog(fileChooser, "The file " + file.getPath() + " already exists.  Overwrite?", "Warning", 0);
                        if (r == 0) {
                            this.saveFile(file);
                        }
                    } else {
                        this.saveFile(file);
                    }
                }
            }
        });
        controlbar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LOAD_ON_TOOLBAR), new ActionListener(){
            SavedFiltersPanel savedFiltersPanel;

            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooser.setFileFilter(SearchBar.this.filenameFilter);
                if (fileChooser.showOpenDialog(MedSavantFrame.getInstance()) == 0) {
                    File file = fileChooser.getSelectedFile();
                    if (file.exists()) {
                        SearchBar.this.getQueryViewController().loadConditions(file);
                    } else {
                        DialogUtils.displayError("File " + file.getPath() + " does not exist!");
                    }
                }
            }
        });
        controlbar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.HISTORY_ON_TOOLBAR), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dHistory.setVisible(true);
            }
        });
        controlbar.createAndAddButton((Icon)IconFactory.getInstance().getIcon(IconFactory.StandardIcon.ACTION_ON_TOOLBAR), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu actionPopup = new JPopupMenu();
                JMenuItem exportAction = new JMenuItem("Export VCF");
                exportAction.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            new ExportVCFWizard().setVisible(true);
                        }
                        catch (Exception ex) {
                            ClientMiscUtils.reportError("Unable to launch Variant Export wizard: %s", ex);
                        }
                    }
                });
                actionPopup.add(exportAction);
                JMenu analyzeWith = new JMenu("Analyze with...");
                actionPopup.add(analyzeWith);
                Set handlers = AppCommRegistry.getInstance().getHandlersForEvent(VariantResultComm.class);
                final VariantResultComm event = new VariantResultComm(null);
                for (final AppCommHandler handler : handlers) {
                    JMenuItem item = new JMenuItem(handler.getHandlerName());
                    ImageIcon icon = handler.getHandlerIcon();
                    if (icon != null) {
                        int iconSize = 22;
                        Image img = ViewUtil.getScaledInstance(icon.getImage(), iconSize, iconSize, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                        item.setIcon(new ImageIcon(img));
                    }
                    ActionListener l = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            handler.handleCommEvent((Object)event);
                        }
                    };
                    item.addActionListener(l);
                    analyzeWith.add(item);
                }
                actionPopup.show(controlbar.getComponent(), 124, 0);
            }
        });
        JPanel instead = this.getSearchComponent();
        this.setFocusable(true);
        this.add((Component)instead, "Center");
        this.add((Component)controlbar.getComponent(), "South");
    }

    public void loadFilters(FilterState ... states) {
        try {
            for (QueryPanel qp : this.queryPanels) {
                for (FilterState state : states) {
                    qp.loadFilterView(state);
                }
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to apply requested filters: %s", ex);
        }
    }

    private JPanel getSearchComponent() {
        SearchConditionGroupItem entireQueryModel = new SearchConditionGroupItem(null);
        this.queryViewController = new QueryViewController(entireQueryModel, MedSavantConditionViewGenerator.getInstance());
        JPanel p = new JPanel();
        p.setFocusable(true);
        p.setOpaque(false);
        p.setLayout(new BorderLayout());
        p.add((Component)this.queryViewController, "Center");
        return p;
    }

    public QueryViewController getQueryViewController() {
        return this.queryViewController;
    }
}

