/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.geneset;

import javax.swing.JPanel;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.util.GeneFetcher;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedTableView;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.GeneSet;
import org.ut.biolab.medsavant.shared.serverapi.GeneSetManagerAdapter;

public class GeneSetPage
extends AppSubSection {
    private SplitScreenView view;
    private final GeneSetManagerAdapter manager = MedSavantClient.GeneSetManager;

    public GeneSetPage(MultiSectionApp parent) {
        super(parent, "Standard Gene Sets");
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new SplitScreenView(new SimpleDetailedListModel<GeneSet>("Gene Sets"){

                public GeneSet[] getData() throws Exception {
                    return GeneSetPage.this.manager.getGeneSets(LoginController.getSessionID());
                }
            }, new GenesDetailedView(), new DetailedListEditor());
        }
        return this.view;
    }

    public void update() {
        this.view.refresh();
    }

    private class GenesDetailedView
    extends DetailedTableView<GeneSet> {
        public GenesDetailedView() {
            super(GeneSetPage.this.pageName, "", "Multiple gene sets (%d)", new String[]{"Name", "Chromosome", "Start", "End", "Coding Start", "Coding End"});
        }

        @Override
        public MedSavantWorker createWorker() {
            return new GeneFetcher((GeneSet)this.selected.get(0), GeneSetPage.this.pageName){

                @Override
                public void setData(Object[][] data) {
                    GenesDetailedView.this.setData(data);
                }

                @Override
                public void showProgress(double prog) {
                }
            };
        }
    }
}

