/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.ontology;

import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.ontology.OntologyWizard;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.UserLevel;

class OntologyDetailedListEditor
extends DetailedListEditor {
    OntologyDetailedListEditor() {
    }

    @Override
    public boolean doesImplementAdding() {
        return LoginController.getInstance().getUserLevel() == UserLevel.ADMIN;
    }

    @Override
    public boolean doesImplementDeleting() {
        return LoginController.getInstance().getUserLevel() == UserLevel.ADMIN;
    }

    @Override
    public void addItems() {
        try {
            new OntologyWizard().setVisible(true);
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error fetching standard genes: %s", ex);
        }
    }

    @Override
    public void deleteItems(final List<Object[]> items) {
        int result;
        String message;
        String caption;
        if (items.size() == 1) {
            caption = "Removing Ontology";
            message = "Removing ontology.  Please wait.";
            result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This cannot be undone.</html>", items.get(0)[0]);
        } else {
            caption = "Removing Ontologies";
            message = "Removing ontologies.  Please wait.";
            result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove these %d ontologies?<br>This cannot be undone.</html>", items.size());
        }
        if (result == 0) {
            new ProgressDialog(caption, message){

                @Override
                public void run() {
                    int numCouldntRemove = 0;
                    for (int i = 0; i < items.size(); ++i) {
                        String ontName = ((Object[])items.get(i))[0].toString();
                        try {
                            MedSavantClient.OntologyManager.removeOntology(LoginController.getSessionID(), ontName);
                            continue;
                        }
                        catch (Throwable ex) {
                            ++numCouldntRemove;
                            this.setVisible(false);
                            ClientMiscUtils.reportError("Could not remove " + ontName + ": %s", ex);
                        }
                    }
                    this.setVisible(false);
                    if (numCouldntRemove != items.size()) {
                        DialogUtils.displayMessage(String.format("Successfully removed %d %s.", items.size(), items.size() > 1 ? "ontologies" : "ontology"));
                    }
                }
            }.setVisible(true);
        }
    }
}

