/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.ontology;

import com.healthmarketscience.sqlbuilder.Condition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.region.RegionSetFilter;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.OntologyType;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class OntologyFilter
extends RegionSetFilter {
    private static final Log LOG = LogFactory.getLog(OntologyFilter.class);
    private final List<OntologyTerm> appliedTerms;
    private final OntologyType ontology;

    public OntologyFilter(List<OntologyTerm> applied, OntologyType ont) {
        this.appliedTerms = applied;
        this.ontology = ont;
    }

    @Override
    public Condition[] getConditions() throws InterruptedException, SQLException, RemoteException {
        Map<OntologyTerm, String[]> allTermsGenes;
        HashSet<Gene> genes = new HashSet<Gene>();
        try {
            allTermsGenes = MedSavantClient.OntologyManager.getGenesForTerms(LoginController.getSessionID(), this.appliedTerms.toArray(new OntologyTerm[0]), ReferenceController.getInstance().getCurrentReferenceName());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
        for (String[] termGenes : allTermsGenes.values()) {
            for (String geneName : termGenes) {
                Gene g = GeneSetController.getInstance().getGene(geneName);
                if (g != null) {
                    genes.add(g);
                    continue;
                }
                LOG.info((Object)("Non-existent gene " + geneName + " referenced by " + (Object)((Object)this.ontology)));
            }
        }
        ArrayList<GenomicRegion> regions = new ArrayList<GenomicRegion>(genes.size());
        boolean i = false;
        for (Gene g : genes) {
            regions.add(new GenomicRegion(g.getName(), g.getChrom(), g.getStart(), g.getEnd()));
        }
        return this.getConditions(regions);
    }

    @Override
    public String getID() {
        return OntologyFilter.ontologyToFilterID(this.ontology);
    }

    @Override
    public String getName() {
        return OntologyFilter.ontologyToTitle(this.ontology);
    }

    public static String ontologyToTitle(OntologyType ontology) {
        switch (ontology) {
            case GO: {
                return "GO \u2013 Gene Ontology";
            }
            case HPO: {
                return "HPO \u2013 Human Phenotype Ontology";
            }
            case OMIM: {
                return "OMIM";
            }
        }
        return null;
    }

    public static String ontologyToFilterID(OntologyType ontology) {
        return ontology.toString();
    }

    public static OntologyType filterIDToOntology(String filterID) {
        return Enum.valueOf(OntologyType.class, filterID);
    }
}

