/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.dialog.IndividualSelector;
import org.ut.biolab.medsavant.component.field.editable.OnClickEditableField;
import org.ut.biolab.medsavant.component.field.editable.StringEditableField;

class EditablePatientField
extends OnClickEditableField<String> {
    private final JButton button;
    private String editorValue;
    private final ActionListener actionListener;
    private final JPanel view = new JPanel();
    private final StringEditableField textOver;

    public EditablePatientField(boolean stringOverride) {
        this.view.setOpaque(false);
        this.view.setLayout((LayoutManager)new MigLayout("insets 0, hidemode 3"));
        this.button = new JButton();
        this.button.setFocusable(false);
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualSelector s = new IndividualSelector(true);
                s.setVisible(true);
                Set<String> selected = s.getHospitalIDsOfSelectedIndividuals();
                if (!selected.isEmpty()) {
                    EditablePatientField.this.editorValue = (String)selected.toArray()[0];
                    EditablePatientField.this.textOver.setValue((Object)EditablePatientField.this.editorValue);
                }
            }
        };
        this.button.addActionListener(this.actionListener);
        this.setAcceptButtonVisible(true);
        this.textOver = new StringEditableField(){

            public void didToggleEditMode(boolean editMode) {
                if (!editMode) {
                    try {
                        EditablePatientField.this.editorValue = this.getValueFromEditor();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        };
        this.textOver.setAutonomousEditingEnabled(stringOverride);
        this.view.add((Component)this.textOver);
        this.view.add(this.button);
    }

    public void updateEditorRepresentationForValue(String value) {
        this.button.setText("Choose...");
        if (value == null) {
            this.textOver.setValue((Object)"");
        } else {
            this.textOver.setValue((Object)value);
        }
    }

    public JComponent getEditor() {
        return this.view;
    }

    public String getValueFromEditor() {
        return this.editorValue;
    }

    public void didToggleEditMode(boolean editMode) {
    }
}

