/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.patient.PatientFormController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.dialog.CancellableProgressDialog;
import org.ut.biolab.medsavant.client.view.dialog.FormEditorDialog;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.ProgressStatus;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.UserLevel;
import org.ut.biolab.medsavant.shared.util.ExtensionFileFilter;
import org.ut.biolab.medsavant.shared.util.ExtensionsFileFilter;

public class IndividualDetailEditor
extends DetailedListEditor {
    @Override
    public boolean doesImplementAdding() {
        return LoginController.getInstance().getUserLevel() == UserLevel.ADMIN;
    }

    @Override
    public boolean doesImplementDeleting() {
        return LoginController.getInstance().getUserLevel() == UserLevel.ADMIN;
    }

    @Override
    public boolean doesImplementImporting() {
        return LoginController.getInstance().getUserLevel() == UserLevel.ADMIN;
    }

    @Override
    public boolean doesImplementExporting() {
        return true;
    }

    @Override
    public void addItems() {
        try {
            PatientFormController pfc = new PatientFormController();
            FormEditorDialog fed = new FormEditorDialog(pfc);
            fed.setTitle("Add Patient");
            fed.setVisible(true);
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to present Add Individual form: %s", ex);
        }
    }

    @Override
    public void deleteItems(final List<Object[]> items) {
        int result = items.size() == 1 ? DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This cannot be undone.</html>", items.get(0)[2]) : DialogUtils.askYesNo("Confirm", "Are you sure you want to remove these %d individuals?\nThis cannot be undone.", items.size());
        if (result == 0) {
            final int[] patients = new int[items.size()];
            int index = 0;
            for (Object[] v : items) {
                patients[index++] = (Integer)v[0];
            }
            new ProgressDialog("Removing Individual(s)", patients.length + " individual(s) being removed. Please wait."){

                @Override
                public void run() {
                    try {
                        MedSavantClient.PatientManager.removePatient(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), patients);
                        DialogUtils.displayMessage("Successfully removed " + items.size() + " individual(s)");
                        this.setVisible(false);
                    }
                    catch (Exception ex) {
                        this.setVisible(false);
                        ClientMiscUtils.reportError("Error removing individual(s): %s", ex);
                    }
                }
            }.setVisible(true);
        }
    }

    @Override
    public void importItems() {
        if (DialogUtils.askYesNo("Confirm", "<html>Importing individuals will REPLACE all existing individuals.<br>Are you sure you want to do this?</html>") == 1) {
            return;
        }
        try {
            File file = DialogUtils.chooseFileForOpen("Import File", new ExtensionsFileFilter(new String[]{"csv"}), null);
            if (file != null) {
                MedSavantClient.PatientManager.clearPatients(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
                new ImportProgressDialog(file).showDialog();
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to import individuals. Please make sure the file is in CSV format and that Hospital IDs are unique.", ex);
        }
    }

    @Override
    public void exportItems() {
        try {
            String filename = ProjectController.getInstance().getCurrentProjectName().replace(" ", "") + "-patients-" + System.currentTimeMillis() + ".csv";
            File file = DialogUtils.chooseFileForSave("Export Individuals", filename, ExtensionFileFilter.createFilters(new String[]{"csv"}), null);
            if (file != null) {
                new ExportProgressDialog(file).showDialog();
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to export individuals.", ex);
        }
    }

    private class ExportProgressDialog
    extends CancellableProgressDialog {
        private final File exportFile;

        private ExportProgressDialog(File f) {
            super("Exporting Individuals", String.format("<html>Exporting individuals to <i>%s</i></html>", f.getName()));
            this.exportFile = f;
        }

        @Override
        public void run() throws SQLException, RemoteException, IOException, InterruptedException {
            this.lastStatus = new ProgressStatus("Writing records...", 0.0);
            CustomField[] fields = null;
            List<Object[]> patients = null;
            try {
                fields = MedSavantClient.PatientManager.getPatientFields(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
                patients = MedSavantClient.PatientManager.getPatients(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return;
            }
            CSVWriter out = new CSVWriter((Writer)new BufferedWriter(new FileWriter(this.exportFile, false)), ',', '\"');
            String[] headerList = new String[fields.length - 1];
            for (int i = 1; i < fields.length; ++i) {
                headerList[i - 1] = fields[i].getAlias();
            }
            out.writeNext(headerList);
            int j = 0;
            for (Object[] patient : patients) {
                if (this.cancelled) break;
                String[] line = new String[patient.length - 1];
                for (int i = 1; i < patient.length; ++i) {
                    line[i - 1] = this.valueToString(patient[i]);
                }
                out.writeNext(line);
                Thread.sleep(50L);
                this.lastStatus.fractionCompleted = (double)(++j) / (double)patients.size();
            }
            out.close();
            this.lastStatus.fractionCompleted = 1.0;
        }

        private String valueToString(Object val) {
            if (val == null) {
                return "";
            }
            return val.toString();
        }
    }

    private class ImportProgressDialog
    extends CancellableProgressDialog {
        private File importFile;

        private ImportProgressDialog(File f) {
            super("Importing Individuals", String.format("<html>Importing from <i>%s</i></html>", f.getName()));
            this.importFile = f;
        }

        @Override
        public void run() throws InterruptedException, SQLException, RemoteException, IOException {
            this.lastStatus = new ProgressStatus("Reading records...", -1.0);
            CustomField[] fields = null;
            try {
                fields = MedSavantClient.PatientManager.getPatientFields(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
            }
            CSVReader in = new CSVReader((Reader)new BufferedReader(new FileReader(this.importFile)));
            String[] header = in.readNext();
            if (header != null) {
                String[] line;
                ArrayList<CustomField> headerToField = new ArrayList<CustomField>();
                for (String s : header) {
                    boolean found = false;
                    for (CustomField f : fields) {
                        if (!s.equals(f.getAlias())) continue;
                        headerToField.add(f);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IOException(String.format("No field found for \"%s\".", s));
                }
                while ((line = in.readNext()) != null && !this.cancelled) {
                    ArrayList<String> values = new ArrayList<String>();
                    values.addAll(Arrays.asList(line));
                    for (int i = 0; i < values.size(); ++i) {
                        String s;
                        s = (String)values.get(i);
                        if (s.equals("") || s.equals("null")) {
                            values.set(i, null);
                            continue;
                        }
                        if (((CustomField)headerToField.get(i)).getColumnType() != ColumnType.BOOLEAN) continue;
                        if (s.toLowerCase().equals("true")) {
                            values.set(i, "1");
                            continue;
                        }
                        if (!s.toLowerCase().equals("false")) continue;
                        values.set(i, "0");
                    }
                    try {
                        MedSavantClient.PatientManager.addPatient(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), headerToField, values);
                    }
                    catch (SessionExpiredException ex) {
                        MedSavantExceptionHandler.handleSessionExpiredException(ex);
                    }
                }
                in.close();
            }
        }
    }
}

