/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.filter.StringListFilterView;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.view.genetics.GeneticsFilterPage;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;

public class PatientUtils
implements BasicPatientColumns {
    public static JPopupMenu createPopup(final String famID) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filter1Item = new JMenuItem("Filter by Family");
        filter1Item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneticsFilterPage.getSearchBar().loadFilters(StringListFilterView.wrapState(WhichTable.PATIENT, BasicPatientColumns.FAMILY_ID.getColumnName(), BasicPatientColumns.FAMILY_ID.getAlias(), Arrays.asList(famID)));
            }
        });
        popupMenu.add(filter1Item);
        return popupMenu;
    }

    public static JPopupMenu createPopup(final String[] hospitalIDs) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filter1Item = new JMenuItem(String.format("<html>Filter by %s</html>", hospitalIDs.length == 1 ? "Hospital ID <i>" + hospitalIDs[0] + "</i>" : "Selected Hospital IDs"));
        filter1Item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
                String encodedConditions = StringConditionEncoder.encodeConditions(Arrays.asList(hospitalIDs));
                String description = StringConditionEncoder.getDescription(Arrays.asList(hospitalIDs));
                qvc.replaceFirstLevelItem(BasicPatientColumns.HOSPITAL_ID.getAlias(), encodedConditions, description);
                DialogUtils.displayMessage("Selected Hospital IDS have been added to query.  Click 'Variants' to review and execute search.");
            }
        });
        popupMenu.add(filter1Item);
        return popupMenu;
    }

    public static JPopupMenu createPopup(final int[] patIDs) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filter1Item = new JMenuItem(String.format("<html>Filter by %s</html>", patIDs.length == 1 ? "Patient <i>" + patIDs[0] + "</i>" : "Selected Patients"));
        filter1Item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryUtils.addQueryOnPatients(patIDs);
            }
        });
        popupMenu.add(filter1Item);
        return popupMenu;
    }
}

