/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient.pedigree;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import org.ut.biolab.medsavant.client.patient.pedigree.NameSymbol;
import org.ut.biolab.medsavant.client.patient.pedigree.PedigreeFields;
import org.ut.biolab.medsavant.client.view.font.FontFactory;
import pedviz.view.NodeView;
import pedviz.view.Symbol;
import pedviz.view.rules.Rule;
import pedviz.view.symbols.Symbol2D;

public class PedigreeBasicRule
extends Rule
implements PedigreeFields {
    private int selectedPatientID;
    private float fontSize = 1.0f;
    private boolean patientLabelsShown = true;

    public PedigreeBasicRule() {
        this(-1);
    }

    public PedigreeBasicRule(int patientID) {
        this.selectedPatientID = patientID;
    }

    public void applyRule(NodeView nv) {
        Object hIdPrecursor;
        nv.setColor(Color.white);
        String hospitalIdOfNode = nv.getNode().getId().toString();
        nv.setHintText(hospitalIdOfNode);
        Object affectedPrecursor = nv.getNode().getUserData("AFFECTED");
        if (affectedPrecursor != null) {
            boolean affected;
            boolean bl = affected = 1 == Integer.parseInt(affectedPrecursor.toString());
            if (affected) {
                nv.setColor(Color.BLACK);
            }
        }
        if ((hIdPrecursor = nv.getNode().getUserData("HOSPITAL")) != null) {
            nv.addSymbol((Symbol)new NameSymbol(this.patientLabelsShown));
        }
        nv.setHintText(null);
    }

    void setPatientLabelsShown(boolean b) {
        this.patientLabelsShown = b;
    }

    float getFontSize() {
        return this.fontSize;
    }

    void setFontSize(float f) {
        this.fontSize = f;
    }

    public static class HospitalSymbol
    extends Symbol2D {
        private final String hid;
        private final float fontSize;
        private final boolean patientLabelsShown;

        public HospitalSymbol(String hid, float fontSize, boolean patientLabelsShown) {
            this.hid = hid;
            this.fontSize = fontSize;
            this.patientLabelsShown = patientLabelsShown;
        }

        public void drawSymbol(Graphics2D g2, Point2D.Float position, float size, Color color, Color color1, NodeView nv) {
            if (this.patientLabelsShown) {
                float rheight;
                Font font = new Font(FontFactory.getGeneralFont().getFamily(), 0, 1);
                g2.setFont(font);
                FontMetrics fm = g2.getFontMetrics();
                FontRenderContext frc = g2.getFontRenderContext();
                int gap = 2;
                float height = font.getLineMetrics(this.hid, frc).getHeight();
                float width = fm.stringWidth(this.hid);
                float startX = position.x - width / 2.0f;
                float startY = position.y + size / 2.0f + (float)gap;
                g2.setColor(new Color(255, 255, 255, 200));
                float padding = 0.3f;
                float rx = startX - padding;
                float ry = startY - height - padding;
                float rwid = width + 2.0f * padding;
                float radius = rheight = height + 2.0f * padding;
                RoundRectangle2D.Float rr = new RoundRectangle2D.Float(rx, ry, rwid, rheight, radius, radius);
                float alpha = 0.8f;
                Color topColor = Color.white;
                Color bottomColor = new Color(245, 245, 245);
                g2.setColor(Color.black);
                g2.drawString(this.hid, startX, startY);
            }
        }

        public int getPriority() {
            return 0;
        }
    }
}

