/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient.pedigree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.patient.pedigree.PedigreeBasicRule;
import org.ut.biolab.medsavant.client.patient.pedigree.PedigreeWorker;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import pedviz.algorithms.Sugiyama;
import pedviz.graph.Graph;
import pedviz.loader.CsvGraphLoader;
import pedviz.view.GraphView2D;
import pedviz.view.Symbol;
import pedviz.view.rules.Rule;
import pedviz.view.rules.ShapeRule;
import pedviz.view.symbols.SymbolSexFemale;
import pedviz.view.symbols.SymbolSexMale;
import pedviz.view.symbols.SymbolSexUndesignated;

public class PedigreeCanvas
extends JPanel {
    private Graph graph;
    private PedigreeWorker pedigreeWorker;
    private String familyName;
    private JLabel familyNameLabel;
    private GraphView2D view;
    private PedigreeBasicRule rule;

    public PedigreeCanvas() {
        this.setBackground(ViewUtil.getDefaultBackgroundColor());
        this.initCanvas();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (PedigreeCanvas.this.view != null) {
                    PedigreeCanvas.this.view.updateGraphView();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void initCanvas() {
        this.showWaitPanel();
    }

    public void showPedigreeFor(int patientID) {
        if (this.pedigreeWorker != null) {
            this.pedigreeWorker.cancel(true);
        }
        this.showWaitPanel();
        this.pedigreeWorker = new PedigreeWorker(patientID, this);
        this.pedigreeWorker.execute();
    }

    synchronized void showPedigree(File pedigreeCSVFile, int patientID) {
        System.out.println("Drawing pedigree from file " + pedigreeCSVFile.getAbsolutePath());
        this.graph = new Graph();
        CsvGraphLoader loader = new CsvGraphLoader(pedigreeCSVFile.getAbsolutePath(), ",");
        loader.setSettings("HOSPITAL", "MOM", "DAD");
        loader.load(this.graph);
        Sugiyama s = new Sugiyama(this.graph);
        s.run();
        this.view = new GraphView2D(s.getLayoutedGraph());
        this.view.setSelectionEnabled(false);
        this.view.setZoomEnabled(true);
        this.view.setMovingEnabled(true);
        this.view.addRule((Rule)new ShapeRule("GENDER", (Object)"1", (Symbol)new SymbolSexMale()));
        this.view.addRule((Rule)new ShapeRule("GENDER", (Object)"2", (Symbol)new SymbolSexFemale()));
        this.view.addRule((Rule)new ShapeRule("GENDER", (Object)"0", (Symbol)new SymbolSexUndesignated()));
        this.view.addRule((Rule)new ShapeRule("GENDER", (Object)"null", (Symbol)new SymbolSexUndesignated()));
        this.rule = new PedigreeBasicRule(patientID);
        this.view.addRule((Rule)this.rule);
        this.view.setScale(1.0);
        this.view.centerGraph();
        float fontStepSize = 0.2f;
        JButton zoomFont = ViewUtil.getIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.FONT_INCREASE), 3);
        zoomFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PedigreeCanvas.this.rule.getFontSize() < 10.0f) {
                    PedigreeCanvas.this.rule.setFontSize(PedigreeCanvas.this.rule.getFontSize() + 0.2f);
                    PedigreeCanvas.this.view.updateRules();
                    PedigreeCanvas.this.view.updateGraphView();
                }
            }
        });
        JButton unZoomFont = ViewUtil.getIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.FONT_DECREASE), 3);
        unZoomFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if ((double)PedigreeCanvas.this.rule.getFontSize() >= 0.4) {
                    PedigreeCanvas.this.rule.setFontSize(PedigreeCanvas.this.rule.getFontSize() - 0.2f);
                    PedigreeCanvas.this.view.updateRules();
                    PedigreeCanvas.this.view.updateGraphView();
                }
            }
        });
        final JCheckBox patientLabels = new JCheckBox("Patient Labels");
        patientLabels.setSelected(true);
        patientLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PedigreeCanvas.this.rule.setPatientLabelsShown(patientLabels.isSelected());
                PedigreeCanvas.this.view.updateRules();
                PedigreeCanvas.this.view.updateGraphView();
            }
        });
        JButton help = ViewUtil.getHelpButton("Pedigree Help", "Using the mouse, scroll to zoom and click-and-drag to pan pedigree.", true);
        System.out.println("Placing pedigree in view...");
        this.removeAll();
        JPanel topBar = ViewUtil.getClearPanel();
        this.familyNameLabel = ViewUtil.getLargeSerifLabel(this.familyName);
        topBar.setLayout((LayoutManager)new MigLayout("fillx, insets 0"));
        topBar.add((Component)this.familyNameLabel, "gpx 10000, growx 10000");
        topBar.add((Component)patientLabels, "growx 0, right, split");
        topBar.add(help);
        JPanel placeholder = ViewUtil.getWhiteLineBorderedPanel();
        placeholder.setLayout(new BorderLayout());
        placeholder.add(this.view.getComponent(), "Center");
        this.setBackground(ViewUtil.getLightGrayBackgroundColor());
        int padding = 30;
        this.setBorder(BorderFactory.createEmptyBorder(padding, padding, padding, padding));
        this.setLayout(new BorderLayout());
        this.add((Component)topBar, "North");
        this.add((Component)placeholder, "Center");
        this.updateUI();
    }

    private void showWaitPanel() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        WaitPanel wp = new WaitPanel("Drawing pedigree");
        this.add((Component)wp, "Center");
        this.updateUI();
    }

    public void setFamilyName(String familyID) {
        this.familyName = familyID;
        if (this.familyNameLabel != null) {
            this.familyNameLabel.setText(familyID);
        }
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        PedigreeCanvas pc = new PedigreeCanvas();
        pc.showPedigree(new File("/Users/mfiume/.medsavant/tmp/pedigree1.csv"), 1);
        f.add(pc);
        f.pack();
        f.setVisible(true);
    }
}

