/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.plugin;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppDescriptor
implements Comparable<AppDescriptor> {
    private static final Log LOG = LogFactory.getLog(AppDescriptor.class);
    final String className;
    final String version;
    final String name;
    final String sdkVersion;
    final File file;
    final Category category;

    public AppDescriptor(String className, String version, String name, String sdkVersion, String category, File file) {
        this.className = className;
        this.version = version;
        this.name = name;
        this.sdkVersion = sdkVersion;
        this.category = Category.valueOf(category.toUpperCase());
        this.file = file;
    }

    public String toString() {
        return this.name + "-" + this.version;
    }

    public String getClassName() {
        return this.className;
    }

    public String getID() {
        return this.getName();
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getSDKVersion() {
        return this.sdkVersion;
    }

    public Category getCategory() {
        return this.category;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int compareTo(AppDescriptor t) {
        return (this.name + this.version).compareTo(t.name + t.version);
    }

    public static enum Category {
        VISUALIZATION{

            public String toString() {
                return "Visualization";
            }
        }
        ,
        ANALYSIS{

            public String toString() {
                return "Analysis and Statistics";
            }
        }
        ,
        SEARCH{

            public String toString() {
                return "Search";
            }
        }
        ,
        UTILITY{

            public String toString() {
                return "Utility";
            }
        }
        ,
        DATASOURCE{

            public String toString() {
                return "External Datasource";
            }
        };

    }

    public static enum PluginXMLAttribute {
        ID,
        NAME,
        VALUE,
        VERSION,
        CLASS,
        CATEGORY,
        IGNORED;

    }

    public static enum PluginXMLElement {
        PLUGIN,
        ATTRIBUTE,
        PARAMETER,
        PROPERTY,
        IGNORED;

    }

    public static class AppVersion
    implements Comparable {
        private final int minorVersion;
        private final int majorVersion;
        private final int bugfixVersion;

        public AppVersion(String version) {
            String[] s = version.split("\\.", 0);
            try {
                this.majorVersion = Integer.parseInt(s[0]);
                this.minorVersion = Integer.parseInt(s[1]);
                this.bugfixVersion = Integer.parseInt(s[2]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new AssertionError((Object)("Invalid App Version " + version + ". App Versions must be of the format <major>.<minor>.<bugfix>"));
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + this.minorVersion;
            hash = 59 * hash + this.majorVersion;
            hash = 59 * hash + this.bugfixVersion;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AppVersion other = (AppVersion)obj;
            if (this.minorVersion != other.minorVersion) {
                return false;
            }
            if (this.majorVersion != other.majorVersion) {
                return false;
            }
            return this.bugfixVersion == other.bugfixVersion;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                return -1;
            }
            if (this.getClass() != obj.getClass()) {
                return -1;
            }
            AppVersion other = (AppVersion)obj;
            if (this.majorVersion != other.majorVersion) {
                return new Integer(this.majorVersion).compareTo(new Integer(other.majorVersion));
            }
            if (this.minorVersion != other.minorVersion) {
                return new Integer(this.minorVersion).compareTo(new Integer(other.minorVersion));
            }
            if (this.bugfixVersion != other.bugfixVersion) {
                return new Integer(this.bugfixVersion).compareTo(new Integer(other.bugfixVersion));
            }
            return 0;
        }

        public boolean isNewerThan(AppVersion version) {
            return this.compareTo(version) > 0;
        }
    }
}

