/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.plugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;

public class PluginIndex {
    private static final Log LOG = LogFactory.getLog(PluginIndex.class);
    private Map<String, URL> urls = new HashMap<String, URL>();

    public PluginIndex(URL url) throws IOException {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(ClientNetworkUtils.openStream(url, 5000, 5000));
            if (reader.getVersion() == null) {
                throw new XMLStreamException("Invalid XML at URL " + url);
            }
            boolean done = false;
            String id = null;
            do {
                if (reader.hasNext()) {
                    int t = reader.next();
                    switch (t) {
                        case 1: {
                            String elemName = reader.getLocalName();
                            if (elemName.equals("leaf")) {
                                id = reader.getAttributeValue(null, "id");
                                break;
                            }
                            if (!elemName.equals("url") || id == null) break;
                            try {
                                this.urls.put(id, new URL(reader.getElementText()));
                            }
                            catch (MalformedURLException x) {
                                LOG.warn((Object)String.format("Unable to parse \"%s\" as a plugin URL.", reader.getElementText()));
                            }
                            id = null;
                            break;
                        }
                        case 8: {
                            reader.close();
                            done = true;
                        }
                    }
                    continue;
                }
                throw new XMLStreamException("Malformed XML at " + url);
            } while (!done);
        }
        catch (XMLStreamException x) {
            throw new IOException("Unable to get version number from web-site.", x);
        }
    }

    public URL getPluginURL(String id) {
        return this.urls.get(id);
    }
}

