/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.plugin;

import com.jidesoft.grid.TreeTable;
import com.jidesoft.swing.TableSearchable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.dialog.DownloadDialog;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.TreeBrowserEntry;
import org.ut.biolab.medsavant.client.view.util.TreeBrowserModel;

public class PluginRepositoryDialog
extends JDialog {
    private static final Log LOG = LogFactory.getLog(PluginRepositoryDialog.class);
    private static final TableCellRenderer FILE_RENDERER = new FileRowCellRenderer();
    private TreeTable table;

    PluginRepositoryDialog(Window parent, String title, String buttonText, File xmlFile) throws JDOMException, IOException {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.add(this.getCenterPanel(PluginRepositoryDialog.getDownloadTreeRows(xmlFile)), "Center");
        JPanel bottomBar = new JPanel(new FlowLayout(2, 5, 5));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginRepositoryDialog.this.setVisible(false);
            }
        });
        bottomBar.add(cancelButton);
        JButton installButton = new JButton(buttonText);
        installButton.putClientProperty("JButton.buttonType", "default");
        installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginRepositoryDialog.this.downloadSelectedItem(false);
            }
        });
        bottomBar.add(installButton);
        this.add((Component)bottomBar, "South");
        this.setPreferredSize(new Dimension(800, 500));
        this.pack();
        this.setLocationRelativeTo(parent);
        ClientMiscUtils.registerCancelButton(cancelButton);
    }

    private void downloadSelectedItem(boolean ignoreBranchSelected) {
        TreeBrowserEntry r = (TreeBrowserEntry)this.table.getRowAt(this.table.getSelectedRow());
        if (r != null && r.isLeaf()) {
            DownloadDialog dd = new DownloadDialog((Window)this, true);
            dd.downloadFile(r.getURL(), DirectorySettings.getPluginsDirectory(), null);
            this.setVisible(false);
            if (dd.getDownloadedFile() != null) {
                try {
                    AppController.getInstance().installPlugin(dd.getDownloadedFile());
                }
                catch (Throwable x) {
                    DialogUtils.displayException("Installation Error", String.format("<html>Unable to install <i>%s</i>: %s.</html>", dd.getDownloadedFile().getName(), x), x);
                }
            }
        } else if (!ignoreBranchSelected) {
            DialogUtils.displayMessage("Please select a file");
        }
    }

    private static TreeBrowserEntry parseDocumentTreeRow(Element root) {
        if (root.getName().equals("branch")) {
            ArrayList<TreeBrowserEntry> children = new ArrayList<TreeBrowserEntry>();
            for (Object o : root.getChildren()) {
                Element c = (Element)o;
                children.add(PluginRepositoryDialog.parseDocumentTreeRow(c));
            }
            return new TreeBrowserEntry(root.getAttributeValue("name"), children);
        }
        if (root.getName().equals("leaf")) {
            try {
                return new TreeBrowserEntry(root.getAttributeValue("name"), root.getChildText("type"), root.getChildText("description"), new URL(root.getChildText("url")), root.getChildText("size"));
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)"Error parsing plugin index.", (Throwable)ex);
            }
        }
        return null;
    }

    private static List<TreeBrowserEntry> getDownloadTreeRows(File f) throws JDOMException, IOException {
        ArrayList<TreeBrowserEntry> roots = new ArrayList<TreeBrowserEntry>();
        Document d = new SAXBuilder().build(f);
        Element root = d.getRootElement();
        TreeBrowserEntry treeroot = PluginRepositoryDialog.parseDocumentTreeRow(root);
        roots.add(treeroot);
        return roots;
    }

    public final Component getCenterPanel(List<TreeBrowserEntry> roots) {
        this.table = new TreeTable((TableModel)((Object)new TreeBrowserModel(roots){

            @Override
            public String[] getColumnNames() {
                return new String[]{"Name"};
            }
        }));
        this.table.setSortable(true);
        this.table.setRespectRenderPreferredHeight(true);
        this.table.setExpandAllAllowed(true);
        this.table.setShowTreeLines(false);
        this.table.setSortingEnabled(false);
        this.table.setRowHeight(18);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        this.table.expandFirstLevel();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PluginRepositoryDialog.this.downloadSelectedItem(true);
                }
            }
        });
        this.table.setSelectRowWhenToggling(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(0).setCellRenderer(FILE_RENDERER);
        TableSearchable searchable = new TableSearchable((JTable)this.table){

            protected String convertElementToString(Object item) {
                if (item instanceof TreeBrowserEntry) {
                    return ((TreeBrowserEntry)item).getType();
                }
                return super.convertElementToString(item);
            }
        };
        searchable.setMainIndex(0);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(800, 500));
        return panel;
    }

    public static class FileRowCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof TreeBrowserEntry) {
                TreeBrowserEntry fileRow = (TreeBrowserEntry)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, fileRow.getName(), isSelected, hasFocus, row, column);
                label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                return label;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

