/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.project;

import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.ResultController;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.project.ProjectEvent;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.ProjectDetails;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.ProjectManagerAdapter;

public class ProjectController
extends Controller<ProjectEvent> {
    private static final Log LOG = LogFactory.getLog(ProjectController.class);
    private static ProjectController instance;
    private ProjectManagerAdapter manager = MedSavantClient.ProjectManager;
    private String currentProjectName;
    private int currentProjectID;
    private AnnotationFormat[] currentAnnotationFormats;
    private CustomField[] currentPatientFormat;
    private TableSchema currentVariantTableSchema;
    private TableSchema currentPatientTableSchema;

    private ProjectController() {
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    try {
                        ProjectController.this.setCurrentVariantTable();
                        ProjectController.this.setCurrentAnnotationFormats(null);
                    }
                    catch (Throwable ex) {
                        ClientMiscUtils.reportError("Error while switching reference: %s", ex);
                    }
                }
            }
        });
    }

    public static ProjectController getInstance() {
        if (instance == null) {
            instance = new ProjectController();
        }
        return instance;
    }

    public void removeProject(final String projectName) {
        new ProgressDialog("Removing Project", projectName + " project is being removed.  Please wait."){

            @Override
            public void run() {
                try {
                    ProjectController.this.manager.removeProject(LoginController.getSessionID(), projectName);
                    ProjectController.this.fireEvent(new ProjectEvent(ProjectEvent.Type.REMOVED, projectName));
                }
                catch (Throwable ex) {
                    ClientMiscUtils.reportError("Error removing project: %s", ex);
                }
            }
        }.setVisible(true);
    }

    public int addProject(String projName, CustomField[] fields) throws Exception {
        int projectid = this.manager.addProject(LoginController.getSessionID(), projName, fields);
        this.fireEvent(new ProjectEvent(ProjectEvent.Type.ADDED, projName));
        return projectid;
    }

    public int getProjectID(String projName) throws SQLException, RemoteException {
        try {
            return this.manager.getProjectID(LoginController.getSessionID(), projName);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return 0;
        }
    }

    public String getProjectNameFromID(int projID) throws SQLException, RemoteException {
        try {
            return this.manager.getProjectName(LoginController.getSessionID(), projID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public void setProject(String projName) throws RemoteException, SQLException {
        try {
            if (this.manager.containsProject(LoginController.getSessionID(), projName)) {
                if (this.manager.containsProject(LoginController.getSessionID(), this.currentProjectName) && FilterController.getInstance().hasFiltersApplied() && !DialogUtils.confirmChangeReference(true)) {
                    return;
                }
                this.currentProjectID = this.getProjectID(projName);
                this.currentProjectName = projName;
                this.setCurrentPatientTable();
                ResultController.getInstance().refreshCounts();
                this.fireEvent(new ProjectEvent(ProjectEvent.Type.CHANGED, projName));
            }
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
    }

    public int getCurrentProjectID() {
        return this.currentProjectID;
    }

    public String getCurrentProjectName() {
        return this.currentProjectName;
    }

    public String[] getProjectNames() throws SQLException, RemoteException {
        if (this.manager == null) {
            return new String[0];
        }
        try {
            return this.manager.getProjectNames(LoginController.getSessionID());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public String getCurrentVariantTableName() throws SQLException, RemoteException {
        try {
            return this.manager.getVariantTableName(LoginController.getSessionID(), this.currentProjectID, ReferenceController.getInstance().getCurrentReferenceID(), true);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public String getCurrentVariantSubTableName() throws SQLException, RemoteException {
        try {
            return this.manager.getVariantTableName(LoginController.getSessionID(), this.currentProjectID, ReferenceController.getInstance().getCurrentReferenceID(), true, true);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public DbTable getCurrentVariantTable() {
        return this.currentVariantTableSchema.getTable();
    }

    public TableSchema getCurrentVariantTableSchema() {
        return this.currentVariantTableSchema;
    }

    private void setCurrentVariantTable() throws SQLException, RemoteException {
        try {
            this.currentVariantTableSchema = MedSavantClient.CustomTablesManager.getCustomTableSchema(LoginController.getSessionID(), this.getCurrentVariantTableName());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
    }

    public String getCurrentPatientTableName() throws RemoteException, SQLException {
        try {
            return MedSavantClient.PatientManager.getPatientTableName(LoginController.getSessionID(), this.currentProjectID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public DbTable getCurrentPatientTable() {
        return this.currentPatientTableSchema.getTable();
    }

    public TableSchema getCurrentPatientTableSchema() {
        return this.currentPatientTableSchema;
    }

    private void setCurrentPatientTable() throws SQLException, RemoteException {
        DbColumn dbc = new DbColumn(null, "A", "B", 1, 0);
        try {
            this.currentPatientTableSchema = MedSavantClient.CustomTablesManager.getCustomTableSchema(LoginController.getSessionID(), this.getCurrentPatientTableName());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
    }

    public int[] getAnnotationIDs(int projectID, int refID) throws SQLException, RemoteException {
        int[] annotIDs;
        try {
            annotIDs = MedSavantClient.AnnotationManagerAdapter.getAnnotationIDs(LoginController.getSessionID(), projectID, refID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
        return annotIDs;
    }

    public AnnotationFormat[] getCurrentAnnotationFormats() throws SQLException, RemoteException {
        if (this.currentAnnotationFormats == null) {
            try {
                int[] annotIDs = this.getAnnotationIDs(this.currentProjectID, ReferenceController.getInstance().getCurrentReferenceID());
                AnnotationFormat[] af = new AnnotationFormat[annotIDs.length + 2];
                af[0] = AnnotationFormat.getDefaultAnnotationFormat();
                af[1] = AnnotationFormat.getCustomFieldAnnotationFormat(this.manager.getCustomVariantFields(LoginController.getSessionID(), this.currentProjectID, ReferenceController.getInstance().getCurrentReferenceID(), this.manager.getNewestUpdateID(LoginController.getSessionID(), this.currentProjectID, ReferenceController.getInstance().getCurrentReferenceID(), true)));
                for (int i = 0; i < annotIDs.length; ++i) {
                    af[i + 2] = MedSavantClient.AnnotationManagerAdapter.getAnnotationFormat(LoginController.getSessionID(), annotIDs[i]);
                }
                this.currentAnnotationFormats = af;
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
        }
        return this.currentAnnotationFormats;
    }

    public CustomField[] getCurrentPatientFormat() throws RemoteException, SQLException {
        if (this.currentPatientFormat == null) {
            try {
                this.currentPatientFormat = MedSavantClient.PatientManager.getPatientFields(LoginController.getSessionID(), this.currentProjectID);
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
        }
        return this.currentPatientFormat;
    }

    public void setCurrentAnnotationFormats(AnnotationFormat[] formats) {
        this.currentAnnotationFormats = formats;
    }

    public void setDefaultReference() throws RemoteException, SQLException {
        String[] references;
        try {
            references = this.manager.getReferenceNamesForProject(LoginController.getSessionID(), this.currentProjectID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        ReferenceController.getInstance().setReference(references[references.length - 1]);
    }

    public boolean promptForUnpublished() throws SQLException, RemoteException {
        ProjectDetails[] unpublishedTables;
        try {
            unpublishedTables = this.manager.getUnpublishedChanges(LoginController.getSessionID());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return false;
        }
        int refID = ReferenceController.getInstance().getCurrentReferenceID();
        for (ProjectDetails pd : unpublishedTables) {
            if (pd.getProjectID() != this.currentProjectID || pd.getReferenceID() != refID || this.promptToPublish(pd)) continue;
            return false;
        }
        return true;
    }

    public boolean promptToPublish(ProjectDetails pd) {
        Object[] options = new Object[]{"Publish", "Delete (Undo Changes)", "Cancel"};
        int option = JOptionPane.showOptionDialog(null, "<HTML>Publishing this table will log all users out of MedSavant, and restart the program. <BR>Are you sure you want to proceed?</HTML>", "Confirm", 1, 3, null, options, options[2]);
        if (option == 1) {
            try {
                MedSavantClient.VariantManager.cancelPublish(LoginController.getSessionID(), pd.getProjectID(), pd.getReferenceID(), pd.getUpdateID());
                return true;
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Error cancelling publication of variants: %s", ex);
            }
        } else if (option == 0) {
            try {
                this.publishVariants(LoginController.getSessionID(), pd.getProjectID(), pd.getReferenceID(), pd.getUpdateID(), null);
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Error publishing variants: %s", ex);
            }
        }
        return false;
    }

    public void publishVariants(String sessionID, int projectID, int referenceID, int updateID, String msg) {
        try {
            MedSavantFrame.getInstance().dispose();
            if (msg != null) {
                DialogUtils.displayMessage(msg);
            }
            if (referenceID > 0 && updateID > 0) {
                MedSavantClient.VariantManager.publishVariants(sessionID, projectID, referenceID, updateID);
            } else {
                MedSavantClient.VariantManager.publishVariants(sessionID, projectID);
            }
            MedSavantFrame.getInstance().forceRestart();
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public void publishVariants(String sessionID, int projectId, String msg) {
        this.publishVariants(sessionID, projectId, -1, -1, msg);
    }
}

