/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.project.ProjectEvent;
import org.ut.biolab.medsavant.client.project.ProjectWizard;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.ProjectDetails;

public class ProjectManagementPage
extends AppSubSection {
    private static final Log LOG = LogFactory.getLog(ProjectManagementPage.class);
    private ProjectController controller = ProjectController.getInstance();
    private SplitScreenView view;

    public ProjectManagementPage(MultiSectionApp parent) {
        super(parent, "Projects");
        this.controller.addListener(new Listener<ProjectEvent>(){

            @Override
            public void handleEvent(ProjectEvent event) {
                if (ProjectManagementPage.this.view != null) {
                    ProjectManagementPage.this.view.refresh();
                }
            }
        });
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new SplitScreenView(new SimpleDetailedListModel<String>("Projects"){

                public String[] getData() throws Exception {
                    return ProjectController.getInstance().getProjectNames();
                }
            }, new ProjectsDetailedView(), new ProjectDetailedListEditor());
        }
        return this.view;
    }

    @Override
    public Component[] getSubSectionMenuComponents() {
        Component[] result = new Component[]{};
        return result;
    }

    private class ProjectsDetailedView
    extends DetailedView {
        private String projectName;
        private DetailsWorker detailsWorker;
        private JPanel details;
        private final BlockingPanel blockingPanel;
        private final StandardFixableWidthAppPanel canvas;

        public ProjectsDetailedView() {
            super(ProjectManagementPage.this.pageName);
            this.canvas = new StandardFixableWidthAppPanel();
            this.blockingPanel = new BlockingPanel("No project selected", this.canvas);
            this.details = this.canvas.addBlock("Basic Information");
            this.blockingPanel.block();
            this.setLayout(new BorderLayout());
            this.add((Component)this.blockingPanel, "Center");
        }

        @Override
        public void setSelectedItem(Object[] item) {
            if (item.length == 0) {
                this.blockingPanel.block();
                return;
            }
            this.projectName = (String)item[0];
            this.refreshSelectedProject();
        }

        private void refreshSelectedProject() {
            this.canvas.setTitle(this.projectName);
            this.details.removeAll();
            this.details.updateUI();
            if (this.detailsWorker != null) {
                this.detailsWorker.cancel(true);
            }
            this.detailsWorker = new DetailsWorker(this.projectName);
            this.detailsWorker.execute();
        }

        private synchronized void setDetailsList(ProjectDetails[] projectDetails) {
            this.details.removeAll();
            ViewUtil.setBoxYLayout(this.details);
            String[][] values = new String[projectDetails.length][2];
            for (int i = 0; i < projectDetails.length; ++i) {
                values[i][0] = projectDetails[i].getReferenceName();
                values[i][1] = projectDetails[i].getNumAnnotations() + " annotation(s) applied";
            }
            this.details.add(ViewUtil.getKeyValuePairList(values));
            int projectID = projectDetails[0].getProjectID();
            if (projectID == ProjectController.getInstance().getCurrentProjectID()) {
                JPanel p = ViewUtil.getClearPanel();
                ViewUtil.applyHorizontalBoxLayout(p);
                p.add(ViewUtil.getGrayItalicizedLabel("This is the current project."));
                p.add(Box.createHorizontalGlue());
                this.details.add(Box.createVerticalStrut(10));
                this.details.add(p);
            }
            String sessionID = LoginController.getSessionID();
            try {
                if (MedSavantClient.SettingsManager.isProjectLockedForChanges(sessionID, projectID)) {
                    JPanel p = ViewUtil.getClearPanel();
                    ViewUtil.applyHorizontalBoxLayout(p);
                    p.add(ViewUtil.getGrayItalicizedLabel("This project is locked. Administrators cannot make further changes."));
                    JButton b = new JButton("Unlock");
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            try {
                                int result = DialogUtils.askYesNo("Warning", "Unlocking the database while another administrator is making changes can\ncause permanent damage. Only unlock if you are sure no one is in the process of\nmaking changes. Are you sure you want to proceed?");
                                if (result == 0) {
                                    MedSavantClient.SettingsManager.forceReleaseLockForProject(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
                                    ProjectsDetailedView.this.refreshSelectedProject();
                                }
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex);
                            }
                        }
                    });
                    JButton refreshButton = ViewUtil.getRefreshButton();
                    p.add(b);
                    p.add(Box.createHorizontalGlue());
                    this.details.add(Box.createVerticalStrut(10));
                    this.details.add(p);
                } else {
                    JPanel p = ViewUtil.getClearPanel();
                    ViewUtil.applyHorizontalBoxLayout(p);
                    p.add(ViewUtil.alignLeft(ViewUtil.getGrayItalicizedLabel("This project is unlocked. Administrators can make changes.")));
                    this.details.add(Box.createVerticalStrut(10));
                    this.details.add(p);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.details.updateUI();
            this.blockingPanel.unblock();
        }

        @Override
        public void setMultipleSelections(List<Object[]> items) {
            if (items.isEmpty()) {
                this.canvas.setTitle("");
            } else {
                this.canvas.setTitle("Multiple projects (" + items.size() + ")");
            }
            this.details.removeAll();
            this.details.updateUI();
            this.blockingPanel.unblock();
        }

        private class DetailsWorker
        extends MedSavantWorker<ProjectDetails[]> {
            private String projectName;
            Dimension buttonDim;

            public DetailsWorker(String projectName) {
                super(ProjectManagementPage.this.pageName);
                this.buttonDim = new Dimension(100, 23);
                this.projectName = projectName;
            }

            @Override
            protected ProjectDetails[] doInBackground() throws Exception {
                int projectId = ProjectController.getInstance().getProjectID(this.projectName);
                return MedSavantClient.ProjectManager.getProjectDetails(LoginController.getSessionID(), projectId);
            }

            @Override
            protected void showProgress(double fraction) {
            }

            @Override
            protected void showSuccess(ProjectDetails[] result) {
                ProjectsDetailedView.this.setDetailsList(result);
            }
        }
    }

    private class ProjectDetailedListEditor
    extends DetailedListEditor {
        private ProjectDetailedListEditor() {
        }

        @Override
        public boolean doesImplementAdding() {
            return true;
        }

        @Override
        public boolean doesImplementDeleting() {
            return true;
        }

        @Override
        public boolean doesImplementEditing() {
            return true;
        }

        @Override
        public void addItems() {
            try {
                new ProjectWizard().setVisible(true);
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Unable to launch project wizard: %s", ex);
            }
        }

        @Override
        public void editItem(Object[] items) {
            try {
                String projName = (String)items[0];
                String sessionID = LoginController.getSessionID();
                int projID = MedSavantClient.ProjectManager.getProjectID(sessionID, projName);
                if (ProjectController.getInstance().promptForUnpublished()) {
                    if (!MedSavantClient.SettingsManager.isProjectLockedForChanges(sessionID, ProjectController.getInstance().getCurrentProjectID())) {
                        ProjectWizard wiz = new ProjectWizard(projID, projName, MedSavantClient.PatientManager.getCustomPatientFields(sessionID, projID), MedSavantClient.ProjectManager.getProjectDetails(sessionID, projID));
                        wiz.setVisible(true);
                    } else {
                        DialogUtils.displayMessage("Cannot Modify Project", "This project is currently locked for changes.\nTo unlock, see the Projects page in the Administration section.");
                    }
                }
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Error checking for changes: %s", ex);
            }
        }

        @Override
        public void deleteItems(List<Object[]> items) {
            int result;
            int nameIndex = 0;
            int keyIndex = 0;
            if (items.size() == 1) {
                String name = (String)items.get(0)[nameIndex];
                result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This cannot be undone.</html>", name);
            } else {
                result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove these %d projects?<br>This cannot be undone.</html>", items.size());
            }
            if (result == 0) {
                boolean didRequestToRemoveCurrentProject = false;
                for (Object[] v : items) {
                    String projectName = (String)v[keyIndex];
                    if (projectName.equals(ProjectController.getInstance().getCurrentProjectName())) {
                        didRequestToRemoveCurrentProject = true;
                    }
                    ProjectManagementPage.this.controller.removeProject(projectName);
                }
                try {
                    if (didRequestToRemoveCurrentProject) {
                        DialogUtils.displayMessage("Successfully removed " + items.size() + " project(s).\n\n" + "The current project was removed.\nYou'll now be logged out.");
                        MedSavantFrame.getInstance().forceRestart();
                    } else {
                        DialogUtils.displayMessage("Successfully removed " + items.size() + " project(s)");
                    }
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Unable to get updated project list: %s.", ex);
                }
            }
        }
    }
}

