/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.project;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.controller.ResultController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class ProjectSummaryPage
extends AppSubSection {
    private static final Log LOG = LogFactory.getLog(ProjectSummaryPage.class);
    private final String projectName = ProjectController.getInstance().getCurrentProjectName();
    private final int projectID = ProjectController.getInstance().getCurrentProjectID();

    ProjectSummaryPage(MultiSectionApp parent) {
        super(parent, "Summary");
    }

    @Override
    public JPanel getView() {
        JPanel view = new JPanel();
        ViewUtil.applyVerticalBoxLayout(view);
        JLabel title = new JLabel(ProjectController.getInstance().getCurrentProjectName() + " Project");
        title.setBorder(ViewUtil.getBigBorder());
        title.setOpaque(false);
        title.setFont(ViewUtil.getMediumTitleFont());
        CollapsiblePanes panes = new CollapsiblePanes();
        panes.add((Component)this.createPatientSummary());
        panes.add((Component)this.createVariantSummary());
        panes.add((Component)this.createReferenceSummary());
        panes.addExpansion();
        view.add(title);
        view.add((Component)panes);
        return view;
    }

    private static JComponent checkException(String capt, ValueFetcher fetcher) {
        JComponent comp;
        try {
            comp = fetcher.getValue();
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to fetch value for " + capt), (Throwable)ex);
            comp = new JLabel(String.format("<html><font color=\"red\">Unable to fetch value for %s: %s</font>", capt, ClientMiscUtils.getMessage(ex)));
        }
        return comp;
    }

    private CollapsiblePane createPatientSummary() {
        CollapsiblePane p = new CollapsiblePane("Patients");
        p.setStyle(1);
        p.setCollapsible(false);
        p.getContentPane().setLayout(new BorderLayout());
        KeyValuePairPanel kvp = new KeyValuePairPanel();
        p.add((Component)kvp, (Object)"Center");
        ValueFetcher pFetcher = new ValueFetcher(){

            @Override
            public JComponent getValue() throws SQLException, RemoteException {
                try {
                    return new JLabel(ViewUtil.numToString(MedSavantClient.PatientManager.getPatients(LoginController.getSessionID(), ProjectSummaryPage.this.projectID).size()));
                }
                catch (SessionExpiredException ex) {
                    MedSavantExceptionHandler.handleSessionExpiredException(ex);
                    return null;
                }
            }
        };
        ValueFetcher cFetcher = new ValueFetcher(){

            @Override
            public JComponent getValue() throws SQLException, RemoteException {
                try {
                    return new JLabel(ViewUtil.numToString(MedSavantClient.CohortManager.getCohorts(LoginController.getSessionID(), ProjectSummaryPage.this.projectID).length));
                }
                catch (SessionExpiredException ex) {
                    MedSavantExceptionHandler.handleSessionExpiredException(ex);
                    return null;
                }
            }
        };
        String key = "Individuals";
        kvp.addKey(key);
        kvp.setValue(key, ProjectSummaryPage.checkException(key, pFetcher));
        key = "Cohorts";
        kvp.addKey(key);
        kvp.setValue(key, ProjectSummaryPage.checkException(key, cFetcher));
        return p;
    }

    private JPanel createVariantSummary() {
        CollapsiblePane p = new CollapsiblePane("Variants");
        p.setCollapsible(false);
        p.getContentPane().setLayout(new BorderLayout());
        KeyValuePairPanel kvp = new KeyValuePairPanel();
        p.add((Component)kvp, (Object)"Center");
        ValueFetcher vfetcher = new ValueFetcher(){

            @Override
            public JComponent getValue() throws SQLException, RemoteException {
                return new JLabel(ViewUtil.numToString(ResultController.getInstance().getTotalVariantCount()));
            }
        };
        String key = "Variants";
        kvp.addKey(key);
        kvp.setValue(key, ProjectSummaryPage.checkException(key, vfetcher));
        return p;
    }

    private JPanel createReferenceSummary() {
        CollapsiblePane p = new CollapsiblePane("References");
        p.setCollapsible(false);
        p.getContentPane().setLayout(new BorderLayout());
        KeyValuePairPanel kvp = new KeyValuePairPanel();
        p.add((Component)kvp, (Object)"Center");
        ValueFetcher rfetcher = new ValueFetcher(){

            @Override
            public JComponent getValue() throws Exception {
                String[] refs = ReferenceController.getInstance().getReferenceNames();
                String s = "";
                for (String ref : refs) {
                    s = s + ref + ", ";
                }
                if (s.charAt(s.length() - 1) == ' ') {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.charAt(s.length() - 1) == ',') {
                    s = s.substring(0, s.length() - 1);
                }
                return new JLabel(s);
            }
        };
        String key = "References";
        kvp.addKey(key);
        kvp.setValue(key, ProjectSummaryPage.checkException(key, rfetcher));
        key = "Current Reference";
        kvp.addKey(key);
        kvp.setValue(key, ReferenceController.getInstance().getCurrentReferenceName());
        return p;
    }

    static abstract class ValueFetcher {
        ValueFetcher() {
        }

        abstract JComponent getValue() throws Exception;
    }

    static class Cartouche
    extends JPanel {
        private final GridBagConstraints KEY_CONSTRAINTS = new GridBagConstraints();
        private final GridBagConstraints VALUE_CONSTRAINTS = new GridBagConstraints();

        Cartouche() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.KEY_CONSTRAINTS.anchor = 13;
            this.KEY_CONSTRAINTS.insets = new Insets(15, 90, 15, 3);
            this.VALUE_CONSTRAINTS.gridwidth = 0;
            this.VALUE_CONSTRAINTS.anchor = 17;
            this.VALUE_CONSTRAINTS.insets = new Insets(15, 3, 15, 90);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(Color.WHITE);
            g.fillRoundRect(0, 0, w - 1, h - 1, 12, 12);
            g.setColor(Color.GRAY);
            g.drawRoundRect(0, 0, w - 1, h - 1, 12, 12);
        }

        void addRow(String capt, ValueFetcher fetcher) {
            try {
                this.add((Component)new JLabel(capt + ":"), this.KEY_CONSTRAINTS);
                this.add((Component)fetcher.getValue(), this.VALUE_CONSTRAINTS);
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to fetch value for " + capt), (Throwable)ex);
                this.add((Component)new JLabel(String.format("<html><font color=\"red\">Unable to fetch value for %s: %s</font>", capt, ClientMiscUtils.getMessage(ex))), this.VALUE_CONSTRAINTS);
            }
            this.KEY_CONSTRAINTS.insets.top = 0;
            this.VALUE_CONSTRAINTS.insets.top = 0;
        }

        void addRow(String capt, String val) {
            if (capt != null) {
                this.add((Component)new JLabel(capt + ":"), this.KEY_CONSTRAINTS);
            }
            this.add((Component)new JLabel(val), this.VALUE_CONSTRAINTS);
            this.KEY_CONSTRAINTS.insets.top = 0;
            this.VALUE_CONSTRAINTS.insets.top = 0;
        }
    }
}

