/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.client.view.util.list.NiceList;
import org.ut.biolab.medsavant.client.view.util.list.NiceListItem;
import org.ut.biolab.medsavant.client.view.util.list.SubtleBlueNiceListColorScheme;

class QueryConditionDialog
extends JDialog {
    private Map<String, List<String>> categoryToConditionNameMap;
    private String chosenConditionName;
    private NiceList conditionNameList;

    public QueryConditionDialog(Map<String, List<String>> categoryToConditionNameMap) {
        super(MedSavantFrame.getInstance(), "Choose a Search Condition", true);
        this.categoryToConditionNameMap = categoryToConditionNameMap;
        this.initDialog();
    }

    private void initDialog() {
        SplitScreenView view = new SplitScreenView(new SimpleDetailedListModel<String>("Condition Category"){

            public String[] getData() throws Exception {
                Set keys = QueryConditionDialog.this.categoryToConditionNameMap.keySet();
                ArrayList keysList = new ArrayList(keys);
                Collections.sort(keysList);
                Collections.reverse(keysList);
                String[] result = new String[keysList.size()];
                int counter = 0;
                for (String k : keysList) {
                    result[counter++] = k;
                }
                return result;
            }
        }, new DetailedView("Category"){

            private void setCategory(String category) {
                this.removeAll();
                QueryConditionDialog.this.conditionNameList = new NiceList();
                List itemNames = (List)QueryConditionDialog.this.categoryToConditionNameMap.get(category);
                Collections.sort(itemNames);
                for (String s : itemNames) {
                    String[] nameAndDescription = QueryConditionDialog.parseNameAndDescription(s);
                    NiceListItem item = new NiceListItem(nameAndDescription[0], s);
                    item.setDescription(nameAndDescription[1]);
                    QueryConditionDialog.this.conditionNameList.addItem(item);
                }
                JPanel p = new JPanel();
                p.setBackground(QueryConditionDialog.this.conditionNameList.getColorScheme().getBackgroundColor());
                p.setLayout(new BorderLayout());
                JScrollPane scroll = ViewUtil.getClearBorderlessScrollPane(QueryConditionDialog.this.conditionNameList);
                scroll.setHorizontalScrollBarPolicy(31);
                p.add((Component)scroll, "Center");
                this.setLayout(new BorderLayout());
                JPanel searchPanel = new JPanel();
                searchPanel.setLayout((LayoutManager)new MigLayout("fillx"));
                searchPanel.setBorder(ViewUtil.getBottomLineBorder());
                searchPanel.add((Component)QueryConditionDialog.this.conditionNameList.getSearchBar(), "width 300, center");
                searchPanel.setBackground(QueryConditionDialog.this.conditionNameList.getColorScheme().getBackgroundColor());
                JPanel bottomPanel = new JPanel();
                bottomPanel.setBorder(ViewUtil.getTopLineBorder());
                ViewUtil.applyHorizontalBoxLayout(bottomPanel);
                bottomPanel.add(Box.createHorizontalGlue());
                JButton cancel = new JButton("Cancel");
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        QueryConditionDialog.this.chosenConditionName = null;
                        QueryConditionDialog.this.setVisible(false);
                    }
                });
                bottomPanel.add((Component)cancel, "right");
                JButton ok = new JButton("OK");
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        QueryConditionDialog.this.chooseSelectedItem();
                    }
                });
                bottomPanel.add((Component)ok, "right");
                this.add((Component)searchPanel, "North");
                this.add((Component)p, "Center");
                this.add((Component)bottomPanel, "South");
                this.updateUI();
                QueryConditionDialog.this.conditionNameList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        JList list = (JList)evt.getSource();
                        if (evt.getClickCount() == 2) {
                            QueryConditionDialog.this.chooseSelectedItem();
                        }
                    }
                });
            }

            @Override
            public void setSelectedItem(Object[] selectedRow) {
                String category = (String)selectedRow[0];
                this.setCategory(category);
            }

            @Override
            public void setMultipleSelections(List<Object[]> selectedRows) {
            }
        }, new DetailedListEditor(){});
        view.setListColorScheme(new SubtleBlueNiceListColorScheme());
        this.setContentPane(view);
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(MedSavantFrame.getInstance());
    }

    private static String[] parseNameAndDescription(String s) {
        Pattern p = Pattern.compile("([\\w ]*) - ([\\w* ]*)", 2);
        Matcher matcher = p.matcher(s);
        String name = null;
        String description = null;
        if (matcher.find()) {
            name = matcher.group(1);
            description = matcher.group(2);
            return new String[]{name, description};
        }
        return new String[]{name, null};
    }

    public static void main(String[] arg) {
        String[] result = QueryConditionDialog.parseNameAndDescription("Hello there ");
        System.out.println(result[0] + "\n" + result[1]);
    }

    private void chooseSelectedItem() {
        this.chosenConditionName = this.conditionNameList != null ? (String)((NiceListItem)this.conditionNameList.getSelectedValue()).getItem() : null;
        this.setVisible(false);
    }

    String getChosenConditionName() {
        return this.chosenConditionName;
    }
}

