/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query;

import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.ConditionViewGenerator;
import org.ut.biolab.medsavant.client.query.QueryConditionDialog;
import org.ut.biolab.medsavant.client.query.SearchConditionGroupItem;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ConditionUtils;
import org.ut.biolab.medsavant.client.query.view.ConditionPopupGenerator;
import org.ut.biolab.medsavant.client.query.view.PillView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionItemView;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryViewController
extends JPanel
implements SearchConditionItem.SearchConditionListener {
    private static Log LOG = LogFactory.getLog(QueryViewController.class);
    private static final int BOTTOM_SEARCH_TEXTFIELD_WIDTH = 270;
    private final SearchConditionGroupItem rootGroup;
    private final HashMap<SearchConditionItem, SearchConditionItemView> itemToViewMap;
    private Map<SearchConditionGroupItem, Boolean> expandedItemsMap = new HashMap<SearchConditionGroupItem, Boolean>();
    private final ConditionViewGenerator conditionViewGenerator;
    private boolean didChangeSinceLastApply;
    private JButton applyButton;
    private final JLabel warningText;
    private int c = 0;

    public QueryViewController(SearchConditionGroupItem model, ConditionViewGenerator c) {
        this.rootGroup = model;
        this.conditionViewGenerator = c;
        model.addListener(this);
        this.setOpaque(false);
        this.setFocusable(true);
        this.warningText = new JLabel("search conditions have changed");
        this.warningText.setFont(ViewUtil.getSmallTitleFont());
        this.warningText.setForeground(ViewUtil.getSubtleTitleColor());
        this.applyButton = new JButton("Search");
        this.applyButton.setFocusable(false);
        this.setConditionsChanged(false);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryViewController.this.applySearchConditions();
                try {
                    AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("view-event", "SearchPerformed")});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.refreshView();
        this.itemToViewMap = new HashMap();
    }

    public List<Object[]> restrictToRegion(List<GenomicRegion> gr, List<String> alt, int limit) {
        try {
            SearchConditionGroupItem rg;
            Condition r;
            long st = System.currentTimeMillis();
            if (this.rootGroup.getItems().size() > 0) {
                r = this.getSQLConditionsFrom(this.rootGroup);
                rg = QueryUtils.getRegionGroup(gr.get(0), alt.get(0), false);
                r = ComboCondition.and(r, this.getSQLConditionsFrom(rg));
            } else {
                rg = QueryUtils.getRegionGroup(gr.get(0), alt.get(0), false);
                r = this.getSQLConditionsFrom(rg);
            }
            for (int i = 1; i < gr.size(); ++i) {
                SearchConditionGroupItem rg2 = QueryUtils.getRegionGroup(gr.get(i), alt.get(i), false);
                r = ComboCondition.and(r, this.getSQLConditionsFrom(rg2));
            }
            return MedSavantClient.VariantManager.getVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), new Condition[][]{{r}}, 0, limit);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            ex.printStackTrace();
            DialogUtils.displayException("Error", "There was an error performing your search", ex);
            return null;
        }
    }

    public List<Object[]> restrictToRegion(GenomicRegion gr, String alt, int limit) {
        ArrayList<GenomicRegion> grl = new ArrayList<GenomicRegion>(1);
        ArrayList<String> al = new ArrayList<String>(1);
        grl.add(gr);
        al.add(alt);
        return this.restrictToRegion(grl, al, limit);
    }

    private void applySearchConditions() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Condition c = QueryViewController.this.getSQLConditionsFrom(QueryViewController.this.rootGroup);
                    if (c == null) {
                        c = ConditionUtils.TRUE_CONDITION;
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            QueryViewController.this.warningText.setVisible(false);
                            QueryViewController.this.applyButton.setText("Searching...");
                            QueryViewController.this.applyButton.setEnabled(false);
                            QueryViewController.this.applyButton.updateUI();
                        }
                    });
                    FilterController.getInstance().setConditions(c);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            QueryViewController.this.applyButton.setText("Search");
                            QueryViewController.this.applyButton.updateUI();
                        }
                    });
                }
                catch (IllegalArgumentException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogUtils.displayError("Search Error", ex.getMessage());
                        }
                    });
                }
                catch (Exception ex) {
                    LOG.info((Object)ex);
                    ex.printStackTrace();
                    DialogUtils.displayException("Error", "There was an error performing your search", ex);
                }
            }
        });
        t.start();
    }

    public void saveConditions(File file) {
        String xml = this.rootGroup.toXML();
        try {
            PrintWriter out = new PrintWriter(file);
            out.println(xml);
            out.close();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            DialogUtils.displayException("Error", "There was an error saving your search", ex);
        }
    }

    private SearchConditionItem getItemFromXML(Element element, SearchConditionGroupItem parentGroup) throws ParseException {
        String desc;
        SearchConditionGroupItem.QueryRelation qr;
        String name = StringEscapeUtils.unescapeXml((String)element.getAttribute("name"));
        if (element.getAttribute("queryRelation").equalsIgnoreCase("OR")) {
            qr = SearchConditionGroupItem.QueryRelation.OR;
        } else if (element.getAttribute("queryRelation").equalsIgnoreCase("AND")) {
            qr = SearchConditionGroupItem.QueryRelation.AND;
        } else {
            throw new ParseException("Malformed input file contains invalid query relation", 0);
        }
        SearchConditionItem sci = new SearchConditionItem(name, qr, parentGroup);
        String encodedConditions = StringEscapeUtils.unescapeXml((String)element.getAttribute("encodedConditions"));
        if (encodedConditions != null && encodedConditions.length() > 0) {
            sci.setSearchConditionEncoding(encodedConditions);
        }
        if ((desc = element.getAttribute("description")) != null && desc.length() > 0) {
            sci.setDescription(desc);
        }
        this.generateItemViewAndAddToGroup(sci, parentGroup);
        return sci;
    }

    private SearchConditionGroupItem getGroupFromXML(Element rootElement, SearchConditionGroupItem parentGroup) throws ParseException {
        SearchConditionGroupItem scg;
        SearchConditionGroupItem.QueryRelation qr;
        if (!rootElement.getNodeName().toLowerCase().equals("group")) {
            DialogUtils.displayError("ERROR: Malformed/Invalid Input file");
        }
        if (rootElement.getAttribute("queryRelation").equalsIgnoreCase("OR")) {
            qr = SearchConditionGroupItem.QueryRelation.OR;
        } else if (rootElement.getAttribute("queryRelation").equalsIgnoreCase("AND")) {
            qr = SearchConditionGroupItem.QueryRelation.AND;
        } else {
            throw new ParseException("Malformed input file contains invalid query relation", 0);
        }
        String desc = rootElement.getAttribute("description");
        if (parentGroup == null) {
            scg = this.rootGroup;
        } else {
            scg = new SearchConditionGroupItem(qr, null, parentGroup);
            if (desc != null && desc.length() > 0) {
                scg.setDescription(desc);
            }
        }
        NodeList nl = rootElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element el = (Element)n;
            if (el.getNodeName().equalsIgnoreCase("group")) {
                SearchConditionGroupItem childGroup = this.getGroupFromXML(el, scg);
                scg.addItem(childGroup);
                continue;
            }
            if (el.getNodeName().equalsIgnoreCase("item")) {
                SearchConditionItem sci = this.getItemFromXML(el, scg);
                continue;
            }
            throw new ParseException("Malformed input file contains invalid XML element", 0);
        }
        return scg;
    }

    public List<SearchConditionItem> getFirstLevelItemsByDesc(String itemDesc) {
        LinkedList<SearchConditionItem> results = new LinkedList<SearchConditionItem>();
        Object sci = null;
        for (SearchConditionItem i : this.getQueryRootGroup().getItems()) {
            if (i.getDescription() == null || !i.getDescription().equals(itemDesc)) continue;
            results.add(i);
        }
        return results;
    }

    public List<SearchConditionItem> getFirstLevelItemsByName(String itemName) {
        LinkedList<SearchConditionItem> results = new LinkedList<SearchConditionItem>();
        for (SearchConditionItem i : this.getQueryRootGroup().getItems()) {
            if (i.getName() == null || !i.getName().equals(itemName)) continue;
            results.add(i);
        }
        return results;
    }

    public void replaceFirstLevelItem(String name, String encodedConditions, String description) {
        List<SearchConditionItem> sciList = this.getFirstLevelItemsByName(name);
        for (SearchConditionItem sci : sciList) {
            this.getQueryRootGroup().removeItem(sci);
            if (!(sci instanceof SearchConditionGroupItem)) continue;
            this.expandedItemsMap.remove((SearchConditionGroupItem)sci);
        }
        SearchConditionItem sci = new SearchConditionItem(name, SearchConditionGroupItem.QueryRelation.AND, this.getQueryRootGroup());
        this.generateItemViewAndAddToGroup(sci, this.getQueryRootGroup());
        sci.setSearchConditionEncoding(encodedConditions);
        sci.setDescription(description);
    }

    public SearchConditionGroupItem replaceFirstLevelGroup(String groupDesc, List<SearchConditionItem> sciList, SearchConditionGroupItem.QueryRelation qr, boolean listIsItems) {
        List<SearchConditionItem> scgList = this.getFirstLevelItemsByDesc(groupDesc);
        for (SearchConditionItem sci : scgList) {
            this.getQueryRootGroup().removeItem(sci);
            this.expandedItemsMap.remove(sci);
        }
        SearchConditionGroupItem scg = new SearchConditionGroupItem(qr, null, this.getQueryRootGroup());
        scg.setDescription(groupDesc);
        this.getQueryRootGroup().addItem(scg);
        if (sciList != null) {
            for (SearchConditionItem sci : sciList) {
                sci.setParent(scg);
                if (listIsItems) {
                    this.generateItemViewAndAddToGroup(sci, scg);
                    continue;
                }
                scg.addItem(sci);
            }
        }
        return scg;
    }

    private void clearSearch(boolean refresh) {
        try {
            AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("view-event", "SearchCleared")});
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rootGroup.clearItems();
        this.itemToViewMap.clear();
        this.expandedItemsMap.clear();
        if (refresh) {
            this.refreshView();
        }
    }

    public void clearSearch() {
        this.clearSearch(true);
    }

    public void loadConditions(File f) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Element rootElement = db.parse(f).getDocumentElement();
            this.clearSearch(false);
            this.getGroupFromXML(rootElement, null);
            this.refreshView();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            DialogUtils.displayException("Error", "There was an error loading your search", ex);
        }
    }

    public final void refreshView() {
        List<JComponent> cs = this.getComponentsFromQueryModel(this.rootGroup);
        this.setLayout(new BorderLayout());
        JPanel p = ViewUtil.getClearPanel();
        p.setLayout((LayoutManager)new MigLayout("hidemode 1, nogrid, fillx, insets 12 12 12 20"));
        this.removeAll();
        JLabel l = ViewUtil.getEmphasizedLabel("SEARCH CONDITIONS");
        p.add((Component)l, "left");
        p.add((Component)ViewUtil.getHelpButton("How to search", "Type a search condition into the search box, e.g. \"Chromosome\". Press Enter / Return to accept the selected condition name. You'll then be prompted to specify parameters for this condition."), "left, wrap");
        for (JComponent c : cs) {
            p.add((Component)c, "left, wrap");
        }
        p.add((Component)this.warningText, "left, wrap");
        p.add((Component)this.applyButton, "left, wrap, gapy n 1");
        JScrollPane jsp = ViewUtil.getClearBorderlessScrollPane(p);
        jsp.setHorizontalScrollBarPolicy(31);
        this.add((Component)jsp, "Center");
        this.invalidate();
        this.updateUI();
    }

    private String getGroupTitle(SearchConditionGroupItem scg) {
        if (scg.getDescription() != null && scg.getDescription().length() > 0) {
            return (scg.getParent().isFirstItem(scg) ? "" : scg.getRelation().toString()) + " " + scg.getDescription();
        }
        return (scg.getParent().isFirstItem(scg) ? "" : scg.getRelation().toString()) + " " + scg.getItems().size() + " grouped condition(s)";
    }

    private List<JComponent> getComponentsFromQueryModel(SearchConditionGroupItem g) {
        return this.getComponentsFromQueryModel(g, 0);
    }

    private List<JComponent> getComponentsFromQueryModel(SearchConditionGroupItem g, int depth) {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        int w = 0;
        for (final SearchConditionItem item : g.getItems()) {
            if (item instanceof SearchConditionGroupItem) {
                String addition = "";
                if (item.getParent() != null) {
                    addition = (Object)((Object)item.getRelation()) + "";
                }
                final JPanel p = ViewUtil.getClearPanel();
                MigLayout ml = new MigLayout("wrap 1, hidemode 1, insets 2");
                p.setLayout((LayoutManager)ml);
                Border border = ViewUtil.getThickLeftLineBorder();
                p.setBorder(border);
                final PillView pv = new PillView(true);
                pv.indent(depth);
                pv.setActivated(true);
                ActionListener toggleGroupExpand = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        QueryViewController.this.expandedItemsMap.put((SearchConditionGroupItem)item, !p.isVisible());
                        p.setVisible(!p.isVisible());
                        pv.setText(QueryViewController.this.getGroupTitle((SearchConditionGroupItem)item));
                    }
                };
                pv.setExpandListener(toggleGroupExpand);
                pv.setPopupGenerator(new ConditionPopupGenerator(){

                    @Override
                    public JPopupMenu generatePopup() {
                        final SearchConditionGroupItem groupItem = (SearchConditionGroupItem)item;
                        JPopupMenu m = new JPopupMenu();
                        if (!item.getParent().isFirstItem(item)) {
                            JMenuItem b;
                            if (item.getRelation() == SearchConditionGroupItem.QueryRelation.AND) {
                                b = new JMenuItem("Change to \"or\"");
                                b.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent ae) {
                                        item.setRelation(SearchConditionGroupItem.QueryRelation.OR);
                                        pv.setText(QueryViewController.this.getGroupTitle(groupItem));
                                    }
                                });
                                m.add(b);
                            } else {
                                b = new JMenuItem("Change to \"and\"");
                                b.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent ae) {
                                        item.setRelation(SearchConditionGroupItem.QueryRelation.AND);
                                        pv.setText(QueryViewController.this.getGroupTitle(groupItem));
                                    }
                                });
                                m.add(b);
                            }
                        }
                        JMenuItem delgroup = new JMenuItem("Delete");
                        delgroup.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                groupItem.getParent().removeItem(groupItem);
                                QueryViewController.this.refreshView();
                                QueryViewController.this.expandedItemsMap.remove((SearchConditionGroupItem)item);
                            }
                        });
                        m.add(delgroup);
                        return m;
                    }
                });
                SearchConditionGroupItem g2 = (SearchConditionGroupItem)item;
                pv.setText(this.getGroupTitle(g2));
                Boolean exp = this.expandedItemsMap.get((SearchConditionGroupItem)item);
                if (exp == null) {
                    p.setVisible(false);
                    pv.collapse();
                } else {
                    p.setVisible(true);
                    pv.expand();
                }
                components.add(pv);
                for (JComponent c : this.getComponentsFromQueryModel((SearchConditionGroupItem)item, depth + 1)) {
                    p.add((Component)c, "left");
                }
                components.add(p);
                w = pv.getMaximumSize().width;
                continue;
            }
            SearchConditionItemView sciv = this.itemToViewMap.get(item);
            sciv.indent(depth);
            w = sciv.getMaximumSize().width;
            sciv.refresh();
            components.add(sciv);
        }
        if (w == 0) {
            w = 270;
        }
        JComponent c = this.getInputFieldForGroup(g, w);
        components.add(c);
        return components;
    }

    @Override
    public void searchConditionsOrderChanged(SearchConditionItem m) {
        this.setConditionsChanged(true);
        this.refreshView();
    }

    public void registerViewWithItem(SearchConditionItemView editor, SearchConditionItem item) {
        this.itemToViewMap.put(item, editor);
    }

    @Override
    public void searchConditionItemRemoved(SearchConditionItem m) {
        this.itemToViewMap.remove(m);
    }

    public void generateItemViewAndAddToGroup(SearchConditionItem sci, SearchConditionGroupItem parent) {
        SearchConditionItemView view = this.conditionViewGenerator.generateViewForItem(sci);
        this.addItemToGroup(sci, view, parent);
    }

    public SearchConditionItemView generateItemViewAndAddToGroup(String fieldName, SearchConditionGroupItem parent) {
        SearchConditionItem item = new SearchConditionItem(fieldName, parent);
        SearchConditionItemView view = this.conditionViewGenerator.generateViewForItem(item);
        this.addItemToGroup(item, view, parent);
        return view;
    }

    public void addItemToGroup(SearchConditionItem item, SearchConditionItemView view, SearchConditionGroupItem parent) {
        this.registerViewWithItem(view, item);
        parent.addItem(item);
    }

    public void addGroupToGroup(SearchConditionGroupItem child, SearchConditionGroupItem parent) {
        parent.addItem(child);
    }

    public SearchConditionGroupItem getQueryRootGroup() {
        return this.rootGroup;
    }

    private JComponent getInputFieldForGroup(SearchConditionGroupItem g, int width) {
        QueryViewController instance = this;
        Map<String, List<String>> possible = this.conditionViewGenerator.getAllowableItemNames();
        CaseInsensitiveArrayList allPossible = new CaseInsensitiveArrayList();
        for (String key : possible.keySet()) {
            allPossible.addAll((Collection)possible.get(key));
        }
        final JButton addCondition = ViewUtil.getSoftButton("Add search condition...");
        final CustomKeyListener keyListener = new CustomKeyListener(this, possible, allPossible, g);
        addCondition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                keyListener.refreshPopup(addCondition);
            }
        });
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(p);
        p.add(addCondition);
        return p;
    }

    @Override
    public void searchConditionItemAdded(SearchConditionItem m) {
    }

    @Override
    public void searchConditionEdited(SearchConditionItem item) {
        this.setConditionsChanged(true);
    }

    private void setConditionsChanged(boolean b) {
        if (this.applyButton != null) {
            this.warningText.setVisible(b);
            this.applyButton.setSelected(b);
            this.applyButton.setEnabled(b);
        }
    }

    private Condition getSQLConditionsFrom(SearchConditionItem item) throws Exception {
        if (item instanceof SearchConditionGroupItem) {
            SearchConditionGroupItem group = (SearchConditionGroupItem)item;
            Condition childrenConditions = null;
            for (SearchConditionItem child : group.getItems()) {
                if (childrenConditions == null) {
                    childrenConditions = this.getSQLConditionsFrom(child);
                    continue;
                }
                if (child.getRelation() == SearchConditionGroupItem.QueryRelation.AND) {
                    childrenConditions = ComboCondition.and(childrenConditions, this.getSQLConditionsFrom(child));
                    continue;
                }
                if (child.getRelation() != SearchConditionGroupItem.QueryRelation.OR) continue;
                childrenConditions = ComboCondition.or(childrenConditions, this.getSQLConditionsFrom(child));
            }
            return childrenConditions;
        }
        return this.conditionViewGenerator.generateConditionForItem(item);
    }

    public class CaseInsensitiveArrayList
    extends ArrayList<String> {
        @Override
        public boolean contains(Object o) {
            String paramStr = (String)o;
            for (String s : this) {
                if (!paramStr.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }

        public String getInsensitiveMatch(String o) {
            String paramStr = o;
            for (String s : this) {
                if (!paramStr.equalsIgnoreCase(s)) continue;
                return s;
            }
            return null;
        }
    }

    private static class CustomKeyListener {
        private final Map<String, List<String>> possible;
        private final CaseInsensitiveArrayList allPossible;
        private SearchConditionGroupItem group;
        private QueryViewController qvc;
        private ArrayList<JComponent> menuComponents;
        List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        int currentlySelectedIndex;

        public CustomKeyListener(QueryViewController qvc, Map<String, List<String>> p, CaseInsensitiveArrayList ap, SearchConditionGroupItem g) {
            this.qvc = qvc;
            this.possible = p;
            this.allPossible = ap;
            this.group = g;
        }

        public void addItemBasedOnField(String validTerm) {
            final SearchConditionItemView view = this.qvc.generateItemViewAndAddToGroup(validTerm, this.group);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    view.showDialog(view.getLocationOnScreen());
                }
            });
        }

        public void refreshPopup(JComponent parent) {
            QueryConditionDialog m = new QueryConditionDialog(this.possible);
            m.setVisible(true);
            String choice = m.getChosenConditionName();
            if (choice != null) {
                this.addItemBasedOnField(choice);
            }
        }
    }
}

