/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant;

import com.healthmarketscience.sqlbuilder.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.appapi.MedSavantVariantSearchApp;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.plugin.AppDescriptor;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.ConditionViewGenerator;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.medsavant.complex.CohortConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ComprehensiveConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.GenesConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.OntologyConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.PatientConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.RegionSetConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.TagConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.VariantConditionGenerator;
import org.ut.biolab.medsavant.client.query.value.DatabaseConditionGenerator;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionItemView;
import org.ut.biolab.medsavant.shared.appapi.MedSavantApp;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.OntologyType;

public class MedSavantConditionViewGenerator
implements ConditionViewGenerator {
    private static final Log LOG = LogFactory.getLog(MedSavantConditionViewGenerator.class);
    public static String REGIONBASED_CONDITIONS = "Region and Ontologies";
    private final HashMap<String, DatabaseFieldStruct> itemToCustomFieldMap = new HashMap();
    private final HashMap<SearchConditionItem, DatabaseConditionGenerator> itemToConditionGeneratorMap = new HashMap();
    private static MedSavantConditionViewGenerator instance;
    private TreeMap<String, List<String>> allowedMap;
    private Map<String, ComprehensiveConditionGenerator> conditionGenerators = new HashMap<String, ComprehensiveConditionGenerator>();
    public static final String PATIENT_CONDITIONS = "Patients";
    public static final String VARIANT_CONDITIONS = "Variants";
    public static final String OTHER_CONDITIONS = "Other Conditions";

    private MedSavantConditionViewGenerator() {
        MedSavantVariantSearchApp[] searchApps;
        try {
            for (CustomField field : ProjectController.getInstance().getCurrentPatientFormat()) {
                if (!field.isFilterable() || !this.isFilterable(field.getColumnType())) continue;
                String name = field.getAlias();
                PatientConditionGenerator patientFieldCondition = new PatientConditionGenerator(field);
                this.conditionGenerators.put(name, patientFieldCondition);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        try {
            AnnotationFormat[] afs;
            for (AnnotationFormat af : afs = ProjectController.getInstance().getCurrentAnnotationFormats()) {
                for (CustomField field : af.getCustomFields()) {
                    if (!field.isFilterable() || !this.isFilterable(field.getColumnType())) continue;
                    String program = af.getProgram();
                    program = program.equals("VCF") || program.equals("VCF Info") ? "" : " - " + program;
                    String name = field.getAlias() + program;
                    VariantConditionGenerator variantFieldCondition = new VariantConditionGenerator(name, field);
                    this.conditionGenerators.put(name, variantFieldCondition);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        CohortConditionGenerator cohort = new CohortConditionGenerator();
        this.conditionGenerators.put(cohort.getName(), cohort);
        RegionSetConditionGenerator regions = new RegionSetConditionGenerator();
        this.conditionGenerators.put(regions.getName(), regions);
        TagConditionGenerator tag = new TagConditionGenerator();
        this.conditionGenerators.put(tag.getName(), tag);
        OntologyConditionGenerator go = new OntologyConditionGenerator(OntologyType.GO);
        this.conditionGenerators.put(go.getName(), go);
        OntologyConditionGenerator hpo = new OntologyConditionGenerator(OntologyType.HPO);
        this.conditionGenerators.put(hpo.getName(), hpo);
        OntologyConditionGenerator omim = new OntologyConditionGenerator(OntologyType.OMIM);
        this.conditionGenerators.put(omim.getName(), omim);
        GenesConditionGenerator genes = new GenesConditionGenerator();
        this.conditionGenerators.put("Genes", genes);
        for (final MedSavantVariantSearchApp searchApp : searchApps = this.loadSearchApps()) {
            ComprehensiveConditionGenerator generator = new ComprehensiveConditionGenerator(){

                @Override
                public String getName() {
                    return searchApp.getName();
                }

                @Override
                public String category() {
                    return searchApp.category();
                }

                @Override
                public Condition getConditionsFromEncoding(String encoding) throws Exception {
                    return searchApp.getConditionsFromEncoding(encoding);
                }

                @Override
                public SearchConditionEditorView getViewGeneratorForItem(SearchConditionItem item) {
                    return searchApp.getViewGeneratorForItem(item);
                }
            };
            this.conditionGenerators.put(generator.getName(), generator);
        }
        this.init();
    }

    public static MedSavantConditionViewGenerator getInstance() {
        if (instance == null) {
            instance = new MedSavantConditionViewGenerator();
        }
        return instance;
    }

    @Override
    public SearchConditionItemView generateViewForItem(SearchConditionItem item) {
        String conditionName = item.getName();
        if (this.conditionGenerators.containsKey(conditionName)) {
            SearchConditionItemView view = new SearchConditionItemView(item, this.conditionGenerators.get(conditionName).getViewGeneratorForItem(item));
            return view;
        }
        throw new UnsupportedOperationException("No view for item " + conditionName);
    }

    @Override
    public Condition generateConditionForItem(SearchConditionItem item) throws Exception {
        DatabaseConditionGenerator cg = this.itemToConditionGeneratorMap.get(item);
        String conditionName = item.getName();
        if (this.conditionGenerators.containsKey(conditionName)) {
            return this.conditionGenerators.get(conditionName).getConditionsFromEncoding(item.getSearchConditionEncoding());
        }
        throw new UnsupportedOperationException("No condition generator for " + item.getName());
    }

    public final void init() {
        this.allowedMap = new TreeMap();
        this.addMap(this.conditionGenerators);
    }

    @Override
    public Map<String, List<String>> getAllowableItemNames() {
        return this.allowedMap;
    }

    private boolean isFilterable(ColumnType type) {
        switch (type) {
            case INTEGER: 
            case FLOAT: 
            case DECIMAL: 
            case BOOLEAN: 
            case VARCHAR: {
                return true;
            }
        }
        return false;
    }

    private void addMap(Map<String, ComprehensiveConditionGenerator> conditionNameToGeneratorMap) {
        for (String name : conditionNameToGeneratorMap.keySet()) {
            ComprehensiveConditionGenerator gen = conditionNameToGeneratorMap.get(name);
            if (this.allowedMap.containsKey(gen.category())) {
                this.allowedMap.get(gen.category()).add(gen.getName());
                continue;
            }
            ArrayList<String> arr = new ArrayList<String>();
            arr.add(gen.getName());
            this.allowedMap.put(gen.category(), arr);
        }
    }

    private MedSavantVariantSearchApp[] loadSearchApps() {
        LinkedList<MedSavantVariantSearchApp> results = new LinkedList<MedSavantVariantSearchApp>();
        int counter = 0;
        for (AppDescriptor ad : AppController.getInstance().getDescriptors()) {
            MedSavantApp ap = AppController.getInstance().getPlugin(ad.getID());
            if (!(ap instanceof MedSavantVariantSearchApp)) continue;
            results.add((MedSavantVariantSearchApp)ap);
            ++counter;
        }
        return results.toArray(new MedSavantVariantSearchApp[counter]);
    }

    public static class DatabaseFieldStruct {
        private final CustomField field;
        private final WhichTable whichTable;
        private SearchConditionItem item;

        public DatabaseFieldStruct(CustomField field, WhichTable whichTable) {
            this.field = field;
            this.whichTable = whichTable;
        }

        public void setItem(SearchConditionItem item) {
            this.item = item;
        }
    }
}

