/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.query.value.StringConditionValueGenerator;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.util.ChromosomeComparator;

public class MedSavantDatabaseStringConditionValueGenerator
extends StringConditionValueGenerator
implements BasicPatientColumns,
BasicVariantColumns {
    private final CustomField field;
    private final WhichTable whichTable;

    public MedSavantDatabaseStringConditionValueGenerator(CustomField field, WhichTable whichTable) {
        this.field = field;
        this.whichTable = whichTable;
    }

    @Override
    public List<String> getStringValues() {
        String columnName = this.field.getColumnName();
        boolean useCache = false;
        try {
            boolean allowInexactMatch = columnName.equals(PHENOTYPES.getColumnName());
            List<String> results = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), this.whichTable.getName(), columnName, allowInexactMatch, useCache);
            if (columnName.equals(CHROM.getColumnName())) {
                Collections.sort(results, new ChromosomeComparator());
            }
            return results;
        }
        catch (Exception ex) {
            Logger.getLogger(MedSavantDatabaseStringConditionValueGenerator.class.getName()).log(Level.SEVERE, null, ex);
            ArrayList<String> ar = new ArrayList<String>();
            ar.add("Error");
            return ar;
        }
    }
}

