/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import savant.api.util.DialogUtils;

public class GeneSearchConditionEditorView
extends SearchConditionEditorView {
    private static final int[] REFRESH_KEY_CODES = new int[]{10, 32, 9, 65487};
    private static final String GENE_DELIMITER = "\\s+|\\t+|,|\\n|\\r\\n";
    private static final Color GENE_INVALID_COLOR = Color.RED;
    private static final Color GENE_VALID_COLOR = Color.BLACK;
    private static final Dimension PREFERRED_SIZE = new Dimension(80, 150);
    private JTextPane textArea;
    private boolean hasInvalidGene = false;

    public GeneSearchConditionEditorView(SearchConditionItem item) {
        super(item);
    }

    public void clearTextArea() {
        this.textArea.setText(null);
        this.hasInvalidGene = false;
    }

    private void refreshTextArea() {
        this.refreshTextArea(false);
    }

    private void refreshTextArea(boolean clean) {
        String s = this.textArea.getText();
        if (s.isEmpty()) {
            this.hasInvalidGene = true;
            return;
        }
        this.textArea.setText("");
        this.hasInvalidGene = false;
        String[] geneNames = s.trim().split(GENE_DELIMITER);
        try {
            LinkedHashSet<String> geneSet = new LinkedHashSet<String>();
            for (String geneName : geneNames) {
                geneSet.add(geneName.toUpperCase());
            }
            HashSet<String> toRemove = new HashSet<String>();
            for (String geneName : geneSet) {
                if (GeneSetController.getInstance().getGene(geneName.toUpperCase()) == null) {
                    if (!clean) {
                        this.hasInvalidGene = true;
                        this.appendToPane(this.textArea, geneName + "\n", GENE_INVALID_COLOR);
                        continue;
                    }
                    toRemove.add(geneName);
                    continue;
                }
                this.appendToPane(this.textArea, geneName + "\n", GENE_VALID_COLOR);
            }
            geneSet.removeAll(toRemove);
            ArrayList<String> geneList = new ArrayList<String>(geneSet);
            this.item.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(geneList));
            this.item.setDescription(StringConditionEncoder.getDescription(geneList));
        }
        catch (SQLException se) {
            DialogUtils.displayException((String)"Error checking genes", (String)"Error communicating with remote database", (Throwable)se);
        }
        catch (RemoteException re) {
            DialogUtils.displayException((String)"Error checking genes", (String)"Error communicating with remote database", (Throwable)re);
        }
    }

    @Override
    public boolean saveChanges() throws IllegalArgumentException {
        super.saveChanges();
        this.refreshTextArea();
        if (this.textArea.getText().isEmpty()) {
            throw new IllegalArgumentException("Please enter at least one gene");
        }
        if (this.hasInvalidGene) {
            if (DialogUtils.askYesNo((String)"One or more of the entered genes was not recognized.  Do you want to ignore them and continue?") == 1) {
                return false;
            }
            this.refreshTextArea(true);
        }
        return true;
    }

    private void appendToPane(JTextPane tp, String msg, Color c) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        aset = sc.addAttribute(aset, StyleConstants.FontFamily, "Lucida Console");
        aset = sc.addAttribute(aset, StyleConstants.Alignment, 3);
        int len = tp.getDocument().getLength();
        tp.setCaretPosition(len);
        tp.setCharacterAttributes(aset, false);
        tp.replaceSelection(msg);
    }

    @Override
    public void loadViewFromSearchConditionParameters(String encoding) throws SearchConditionEditorView.ConditionRestorationException {
        if (this.textArea != null) {
            return;
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.textArea = new JTextPane();
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                super.mouseReleased(me);
                if (me.getButton() == 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GeneSearchConditionEditorView.this.refreshTextArea();
                        }
                    });
                }
            }
        });
        this.textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                GeneSearchConditionEditorView.this.refreshTextArea();
            }

            @Override
            public void focusLost(FocusEvent fe) {
                GeneSearchConditionEditorView.this.refreshTextArea();
            }
        });
        this.textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent ke) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 65487 || ke.isControlDown() && ke.getKeyCode() == 86 || ke.isShiftDown() && ke.getKeyCode() == 155) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GeneSearchConditionEditorView.this.refreshTextArea();
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                for (int refreshCode : REFRESH_KEY_CODES) {
                    ke.isControlDown();
                    if (ke.getKeyCode() != refreshCode) continue;
                    GeneSearchConditionEditorView.this.refreshTextArea();
                }
            }
        });
        JScrollPane jsp = new JScrollPane(this.textArea);
        p.add((Component)new JLabel("Please type or paste gene names: "), "North");
        p.add((Component)jsp, "Center");
        this.add(p);
        if (encoding != null) {
            List<String> geneNames = StringConditionEncoder.unencodeConditions(encoding);
            this.item.setSearchConditionEncoding(encoding);
            this.item.setDescription(StringConditionEncoder.getDescription(geneNames));
            String s = "";
            for (String geneName : geneNames) {
                s = s + geneName + "\n";
            }
            this.textArea.setText(s);
            this.refreshTextArea();
            this.revalidate();
        }
        this.textArea.setPreferredSize(PREFERRED_SIZE);
    }
}

