/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.reference;

import java.rmi.RemoteException;
import java.sql.SQLException;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.Reference;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.ReferenceManagerAdapter;

public class ReferenceController
extends Controller<ReferenceEvent> {
    private static ReferenceController instance;
    private final ReferenceManagerAdapter manager = MedSavantClient.ReferenceManager;
    private int currentReferenceID;
    private String currentReferenceName;
    private boolean referenceSet = false;

    private ReferenceController() {
    }

    public static ReferenceController getInstance() {
        if (instance == null) {
            instance = new ReferenceController();
        }
        return instance;
    }

    public Reference[] getReferences() throws SQLException, RemoteException {
        try {
            return this.manager.getReferences(LoginController.getSessionID());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public boolean setReference(String refName) throws SQLException, RemoteException {
        return this.setReference(refName, false);
    }

    public boolean setReference(String refName, boolean getConfirmation) throws SQLException, RemoteException {
        try {
            if (this.manager.containsReference(LoginController.getSessionID(), refName)) {
                if (getConfirmation && FilterController.getInstance().hasFiltersApplied() && !DialogUtils.confirmChangeReference(false)) {
                    return false;
                }
                this.currentReferenceID = this.getReferenceID(refName);
                this.currentReferenceName = refName;
                this.fireEvent(new ReferenceEvent(ReferenceEvent.Type.CHANGED, refName));
            }
            this.referenceSet = true;
            return true;
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return false;
        }
    }

    public int getReferenceID(String refName) throws SQLException, RemoteException {
        try {
            return this.manager.getReferenceID(LoginController.getSessionID(), refName);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return 0;
        }
    }

    public int getCurrentReferenceID() {
        return this.currentReferenceID;
    }

    public String[] getReferenceNames() throws SQLException, RemoteException {
        try {
            return this.manager.getReferenceNames(LoginController.getSessionID());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public String getCurrentReferenceName() {
        return this.currentReferenceName;
    }

    public String getCurrentReferenceUrl() {
        try {
            return this.manager.getReferenceUrl(LoginController.getSessionID(), this.currentReferenceID);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Chromosome[] getChromosomes() throws SQLException, RemoteException {
        return this.getChromosomes(this.currentReferenceID);
    }

    public Chromosome[] getChromosomes(int refID) throws SQLException, RemoteException {
        try {
            return this.manager.getChromosomes(LoginController.getSessionID(), refID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public boolean isReferenceSet() {
        return this.referenceSet;
    }

    public void addReference(String name, Chromosome[] chroms, String url) throws SQLException, RemoteException {
        try {
            this.manager.addReference(LoginController.getSessionID(), name, chroms, url);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.fireEvent(new ReferenceEvent(ReferenceEvent.Type.ADDED, name));
    }

    public void removeReference(final String refName) {
        new ProgressDialog("Removing Reference", "Reference " + refName + " is being removed. Please wait."){

            @Override
            public void run() {
                try {
                    ReferenceController.this.manager.removeReference(LoginController.getSessionID(), ReferenceController.this.manager.getReferenceID(LoginController.getSessionID(), refName));
                    ReferenceController.this.fireEvent(new ReferenceEvent(ReferenceEvent.Type.REMOVED, refName));
                }
                catch (Throwable ex) {
                    this.setVisible(false);
                    DialogUtils.displayError("Cannot remove this reference because projects\nor annotations still refer to it.");
                }
            }
        }.setVisible(true);
    }
}

