/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.reference;

import java.util.List;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.reference.NewReferenceDialog;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedTableView;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.Reference;

public class ReferenceGenomePage
extends AppSubSection {
    private ReferenceController controller = ReferenceController.getInstance();
    private SplitScreenView view;

    public ReferenceGenomePage(MultiSectionApp parent) {
        super(parent, "Reference Genomes");
        this.controller.addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (ReferenceGenomePage.this.view != null) {
                    ReferenceGenomePage.this.view.refresh();
                }
            }
        });
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new SplitScreenView(new SimpleDetailedListModel<Reference>("Reference"){

                public Reference[] getData() throws Exception {
                    return ReferenceGenomePage.this.controller.getReferences();
                }
            }, new ReferenceDetailedView(), new ReferenceDetailedListEditor());
        }
        return this.view;
    }

    public void update() {
        this.view.refresh();
    }

    private static class ReferenceDetailedListEditor
    extends DetailedListEditor {
        private ReferenceDetailedListEditor() {
        }

        @Override
        public boolean doesImplementAdding() {
            return true;
        }

        @Override
        public boolean doesImplementDeleting() {
            return true;
        }

        @Override
        public void addItems() {
            new NewReferenceDialog().setVisible(true);
        }

        @Override
        public void deleteItems(List<Object[]> items) {
            int result;
            if (items.size() == 1) {
                String name = ((Reference)items.get(0)[0]).getName();
                result = DialogUtils.askYesNo("Confirm", "Are you sure you want to remove %s?\nThis cannot be undone.", name);
            } else {
                result = DialogUtils.askYesNo("Confirm", "Are you sure you want to remove these %d references?\nThis cannot be undone.", items.size());
            }
            if (result == 0) {
                int numCouldntRemove = 0;
                for (Object[] v : items) {
                    String refName = ((Reference)v[0]).getName();
                    ReferenceController.getInstance().removeReference(refName);
                }
                if (items.size() != numCouldntRemove) {
                    DialogUtils.displayMessage(String.format("Successfully removed %d reference(s)", items.size() - numCouldntRemove));
                }
            }
        }
    }

    private class ReferenceDetailedView
    extends DetailedTableView<Reference> {
        public ReferenceDetailedView() {
            super(ReferenceGenomePage.this.pageName, "", "Multiple references (%d)", new String[]{"Contig Name", "Contig Length", "Centromere Position"});
        }

        @Override
        public MedSavantWorker createWorker() {
            return new MedSavantWorker<Chromosome[]>(ReferenceGenomePage.this.pageName){

                @Override
                protected Chromosome[] doInBackground() throws Exception {
                    return ReferenceGenomePage.this.controller.getChromosomes(((Reference)ReferenceDetailedView.this.selected.get(0)).getID());
                }

                @Override
                protected void showProgress(double fraction) {
                }

                @Override
                protected void showSuccess(Chromosome[] result) {
                    Object[][] list = new Object[result.length][];
                    for (int i = 0; i < result.length; ++i) {
                        Chromosome c = result[i];
                        list[i] = new Object[]{c.getName(), c.getLength(), c.getCentromerePos()};
                    }
                    ReferenceDetailedView.this.setData(list);
                }
            };
        }
    }
}

