/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.region;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.region.RegionController;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.list.DetailedTableView;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.RegionSet;

public class RegionDetailedView
extends DetailedTableView<RegionSet> {
    private final RegionController controller = RegionController.getInstance();

    public RegionDetailedView(String page) {
        super(page, "", "Multiple lists (%d)", new String[]{"Region", "Chromosome", "Start", "End"});
    }

    @Override
    public MedSavantWorker createWorker() {
        return new MedSavantWorker<List<GenomicRegion>>(this.getPageName()){

            @Override
            protected List<GenomicRegion> doInBackground() throws Exception {
                return RegionDetailedView.this.controller.getRegionsInSet((RegionSet)RegionDetailedView.this.selected.get(0));
            }

            @Override
            protected void showProgress(double fract) {
            }

            @Override
            protected void showSuccess(List<GenomicRegion> result) {
                Object[][] list = new Object[result.size()][];
                for (int i = 0; i < result.size(); ++i) {
                    GenomicRegion r = result.get(i);
                    list[i] = new Object[]{r.getName(), r.getChrom(), r.getStart(), r.getEnd()};
                }
                RegionDetailedView.this.setData(list);
            }
        };
    }

    @Override
    public JPopupMenu createTablePopup(final Object[][] selected) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem posItem = new JMenuItem(String.format("<html>Filter by %s</html>", selected.length == 1 ? "Region <i>" + selected[0][0] + "</i>" : "Selected Regions"));
        final List selectedRegions = this.selected;
        posItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ArrayList<GenomicRegion> regions = new ArrayList<GenomicRegion>();
                for (Object[] cols : selected) {
                    String geneName = (String)cols[0];
                    String chrom = (String)cols[1];
                    Integer start = (Integer)cols[2];
                    Integer end = (Integer)cols[3];
                    regions.add(new GenomicRegion(geneName, chrom, start, end));
                }
                QueryUtils.addQueryOnRegions(regions, selectedRegions);
                DialogUtils.displayMessage("Selected genomic regions have been added to query.  Click 'Variants' to review and execute search.");
            }
        });
        menu.add(posItem);
        return menu;
    }

    @Override
    public JPopupMenu createPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        if (ProjectController.getInstance().getCurrentVariantTableSchema() == null) {
            popupMenu.add(new JLabel("(You must choose a variant table before filtering)"));
        } else {
            JMenuItem filter1Item = new JMenuItem(String.format("<html>Filter by %s</html>", this.selected.size() == 1 ? "Region List <i>" + this.selected.get(0) + "</i>" : "Selected Region Lists"));
            filter1Item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
                    ArrayList<String> regionSetNames = new ArrayList<String>(RegionDetailedView.this.selected.size());
                    for (RegionSet rs : RegionDetailedView.this.selected) {
                        regionSetNames.add(rs.getName());
                    }
                    String encodedConditions = StringConditionEncoder.encodeConditions(regionSetNames);
                    String description = StringConditionEncoder.getDescription(regionSetNames);
                    qvc.replaceFirstLevelItem("Region Set", encodedConditions, description);
                    DialogUtils.displayMessage("Selected region sets have been added to query.  Click 'Variants' to review and execute search.");
                }
            });
            popupMenu.add(filter1Item);
        }
        return popupMenu;
    }
}

