/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.region;

import com.healthmarketscience.sqlbuilder.Condition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.TabularFilterView;
import org.ut.biolab.medsavant.client.region.AdHocRegionSet;
import org.ut.biolab.medsavant.client.region.RegionController;
import org.ut.biolab.medsavant.client.region.RegionEvent;
import org.ut.biolab.medsavant.client.region.RegionSetFilter;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.RegionSet;

public class RegionSetFilterView
extends TabularFilterView<RegionSet> {
    public static final String FILTER_NAME = "Region List";
    public static final String FILTER_ID = "region_list";
    private static final String AD_HOC_REGION_SET_NAME = "Selected Regions";
    private static RegionController controller = RegionController.getInstance();

    public RegionSetFilterView(FilterState state, int queryID) throws SQLException, RemoteException {
        this(queryID);
        List<String> names = state.getValues("name");
        List<String> regStrs = state.getValues("region");
        if (regStrs != null && regStrs.size() > 0) {
            ArrayList<GenomicRegion> adHocRegions = new ArrayList<GenomicRegion>(regStrs.size());
            for (String str : regStrs) {
                adHocRegions.add(GenomicRegion.fromString(str));
            }
            this.getAvailableValues().add(controller.createAdHocRegionSet(AD_HOC_REGION_SET_NAME, adHocRegions));
            this.updateModel();
            if (names == null) {
                names = new ArrayList<String>(1);
            }
            names.add(AD_HOC_REGION_SET_NAME);
        }
        if (names != null) {
            this.setFilterValues(names);
        }
    }

    public RegionSetFilterView(int queryID) throws SQLException, RemoteException {
        super(FILTER_NAME, queryID);
        ArrayList<RegionSet> vals = new ArrayList<RegionSet>();
        vals.addAll(controller.getRegionSets());
        this.setAvailableValues(vals);
        this.initContentPanel();
        controller.addListener(new Listener<RegionEvent>(){

            @Override
            public void handleEvent(RegionEvent event) {
                RegionSetFilterView.this.updateModel();
            }
        });
    }

    public static FilterState wrapState(Collection<RegionSet> applied) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<GenomicRegion> adHocRegions = new ArrayList<GenomicRegion>();
        if (applied != null && !applied.isEmpty()) {
            names = new ArrayList();
            for (RegionSet regSet : applied) {
                if (regSet instanceof AdHocRegionSet) {
                    try {
                        adHocRegions.addAll(controller.getRegionsInSet(regSet));
                    }
                    catch (Exception ignored) {}
                    continue;
                }
                names.add(regSet.toString());
            }
        }
        FilterState state = new FilterState(Filter.Type.REGION_LIST, FILTER_NAME, FILTER_ID);
        state.putValues("name", names);
        state.putValues("region", RegionSetFilterView.wrapValues(adHocRegions));
        return state;
    }

    @Override
    public FilterStateAdapter saveState() {
        return RegionSetFilterView.wrapState(this.appliedValues);
    }

    @Override
    protected void applyFilter() {
        this.preapplyFilter();
        FilterController.getInstance().addFilter(new RegionSetFilter(){

            @Override
            public Condition[] getConditions() throws SQLException, RemoteException {
                return this.getConditions(controller.getRegionsInSets(RegionSetFilterView.this.appliedValues));
            }

            @Override
            public String getName() {
                return RegionSetFilterView.FILTER_NAME;
            }

            @Override
            public String getID() {
                return RegionSetFilterView.FILTER_ID;
            }
        }, this.queryID);
    }
}

