/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.user;

import java.rmi.RemoteException;
import java.sql.SQLException;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.user.UserEvent;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.UserLevel;

public class UserController
extends Controller<UserEvent> {
    private static UserController instance;

    public static UserController getInstance() {
        if (instance == null) {
            instance = new UserController();
        }
        return instance;
    }

    public void addUser(String name, char[] pass, UserLevel level) throws SQLException, RemoteException {
        try {
            MedSavantClient.UserManager.addUser(LoginController.getSessionID(), name, pass, level);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.fireEvent(new UserEvent(UserEvent.Type.ADDED, name, level));
    }

    public void removeUser(String name) throws SQLException, RemoteException {
        try {
            MedSavantClient.UserManager.removeUser(LoginController.getSessionID(), name);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.fireEvent(new UserEvent(UserEvent.Type.REMOVED, name, UserLevel.NONE));
    }

    public String[] getUserNames() throws SQLException, RemoteException {
        try {
            return MedSavantClient.UserManager.getUserNames(LoginController.getSessionID());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }
}

