/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.user;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.user.CreateUserDialog;
import org.ut.biolab.medsavant.client.user.UserController;
import org.ut.biolab.medsavant.client.user.UserEvent;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.UserLevel;

public class UserManagementPage
extends AppSubSection
implements Listener<UserEvent> {
    private SplitScreenView view;

    public UserManagementPage(MultiSectionApp parent) {
        super(parent, "Users");
        UserController.getInstance().addListener(this);
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new SplitScreenView(new SimpleDetailedListModel<String>("User"){

                public String[] getData() throws Exception {
                    return UserController.getInstance().getUserNames();
                }
            }, new UserDetailedView(), new UserDetailedListEditor());
            this.view.setSearchBarEnabled(true);
        }
        return this.view;
    }

    @Override
    public Component[] getSubSectionMenuComponents() {
        return new Component[0];
    }

    @Override
    public void handleEvent(UserEvent evt) {
        this.view.refresh();
    }

    private class UserDetailedView
    extends DetailedView {
        private final String[] FIELD_NAMES;
        private final JPanel details;
        private String name;
        private DetailsWorker worker;
        private final BlockingPanel blockingPanel;
        private final StandardFixableWidthAppPanel canvas;

        public UserDetailedView() {
            super(UserManagementPage.this.pageName);
            this.FIELD_NAMES = new String[]{"User Level"};
            this.canvas = new StandardFixableWidthAppPanel();
            this.blockingPanel = new BlockingPanel("No user selected", this.canvas);
            this.details = this.canvas.addBlock();
            this.blockingPanel.block();
            this.setLayout(new BorderLayout());
            this.add((Component)this.blockingPanel, "Center");
        }

        @Override
        public void setSelectedItem(Object[] item) {
            if (item.length == 0) {
                this.blockingPanel.block();
                return;
            }
            this.name = (String)item[0];
            this.canvas.setTitle(this.name);
            this.details.removeAll();
            this.details.updateUI();
            if (this.worker != null) {
                this.worker.cancel(true);
            }
            this.worker = new DetailsWorker(this.name);
            this.worker.execute();
        }

        @Override
        public JPopupMenu createPopup() {
            return null;
        }

        public synchronized void setUserInfoList(String[] info) {
            this.details.removeAll();
            this.details.setLayout(new BorderLayout());
            ViewUtil.setBoxYLayout(this.details);
            String[][] values = new String[this.FIELD_NAMES.length][2];
            for (int i = 0; i < this.FIELD_NAMES.length; ++i) {
                values[i][0] = this.FIELD_NAMES[i];
                values[i][1] = info[0];
            }
            this.details.add(ViewUtil.getKeyValuePairList(values));
            this.details.updateUI();
            this.blockingPanel.unblock();
        }

        @Override
        public void setMultipleSelections(List<Object[]> items) {
            if (items.isEmpty()) {
                this.canvas.setTitle("");
            } else {
                this.canvas.setTitle("Multiple users (" + items.size() + ")");
            }
            this.details.removeAll();
            this.details.updateUI();
        }

        private class DetailsWorker
        extends MedSavantWorker<UserLevel> {
            private String userName;

            public DetailsWorker(String userName) {
                super(UserManagementPage.this.pageName);
                this.userName = userName;
            }

            @Override
            protected UserLevel doInBackground() throws Exception {
                return MedSavantClient.UserManager.getUserLevel(LoginController.getSessionID(), this.userName);
            }

            @Override
            protected void showProgress(double frac) {
            }

            @Override
            protected void showSuccess(UserLevel lev) {
                UserDetailedView.this.setUserInfoList(new String[]{lev.toString()});
            }
        }
    }

    private class UserDetailedListEditor
    extends DetailedListEditor {
        private UserDetailedListEditor() {
        }

        @Override
        public boolean doesImplementAdding() {
            return true;
        }

        @Override
        public boolean doesImplementDeleting() {
            return true;
        }

        @Override
        public void addItems() {
            CreateUserDialog npd = new CreateUserDialog();
            npd.setVisible(true);
        }

        @Override
        public void deleteItems(final List<Object[]> items) {
            int result;
            String name = null;
            if (items.size() == 1) {
                name = (String)items.get(0)[0];
                result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>" + name + "</i>?<br><br>This cannot be undone.</html>");
            } else {
                result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove these " + items.size() + " users?<br><br>This cannot be undone.</html>");
            }
            if (result == 0) {
                String title = "Removing Users";
                String message = items.size() + " users being removed.  Please wait.";
                if (name != null) {
                    title = "Removing User";
                    message = "<html>User <i>" + name + "</i> being removed.  Please wait.</html>";
                }
                new ProgressDialog(title, message){
                    int numCouldntRemove;
                    {
                        super(x0, x1);
                        this.numCouldntRemove = 0;
                    }

                    @Override
                    public void run() {
                        String name = null;
                        try {
                            for (Object[] v : items) {
                                name = (String)v[0];
                                UserController.getInstance().removeUser(name);
                            }
                            this.setVisible(false);
                            if (this.numCouldntRemove != items.size()) {
                                if (items.size() == 1) {
                                    DialogUtils.displayMessage("<html>Removed <i>" + ((Object[])items.get(0))[0] + "</i></html>");
                                } else {
                                    DialogUtils.displayMessage("Removed " + (items.size() - this.numCouldntRemove) + " user(s)");
                                }
                            }
                        }
                        catch (Throwable ex) {
                            this.setVisible(false);
                            ++this.numCouldntRemove;
                            ClientMiscUtils.reportError("Error removing user \"" + name + "\": %s", ex);
                            this.dispose();
                        }
                        this.dispose();
                    }
                }.setVisible(true);
            }
        }
    }
}

