/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.shared.util.ModificationType;

public class CacheController
extends Controller<ModificationType> {
    private static CacheController instance;
    private final Object timerLock;
    private static long minimumWaitInterval;
    private static long periodic_update_interval;
    private Map<ModificationType, Long> timers;
    private Timer timer;
    private EventFiringTask eventFiringTask;
    private Set<Long> threadIds = new HashSet<Long>();

    private CacheController() {
        this.timers = new EnumMap<ModificationType, Long>(ModificationType.class);
        for (ModificationType mt : ModificationType.values()) {
            this.timers.put(mt, System.currentTimeMillis() + periodic_update_interval);
        }
        this.timerLock = new Object();
        this.timer = new Timer();
        this.eventFiringTask = new EventFiringTask();
        this.timer.scheduleAtFixedRate((TimerTask)this.eventFiringTask, minimumWaitInterval, minimumWaitInterval);
    }

    public static void setMinimumWaitInterval(long ms) {
        minimumWaitInterval = ms;
    }

    public static long getMinimumWaitInterval() {
        return minimumWaitInterval;
    }

    public static CacheController getInstance() {
        if (instance == null) {
            instance = new CacheController();
        }
        return instance;
    }

    public void blockUpdate(final Runnable r, final ModificationType[] types) {
        Thread t = new Thread(){

            @Override
            public void run() {
                CacheController.this.threadIds.add(this.getId());
                r.run();
                CacheController.this.threadIds.remove(this.getId());
                for (ModificationType t : types) {
                    CacheController.this.expire(t);
                }
            }
        };
        t.start();
    }

    public void expire(ModificationType t, Long threadId) {
        if (threadId == null || !this.threadIds.contains(threadId)) {
            this.timers.put(t, System.currentTimeMillis() + minimumWaitInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(ModificationType t) {
        Object object = this.timerLock;
        synchronized (object) {
            this.expire(t, null);
        }
    }

    static {
        minimumWaitInterval = 500L;
        periodic_update_interval = 900000L;
    }

    private class EventFiringTask
    extends TimerTask {
        private Map<ModificationType, MedSavantWorker<Void>> threadMap = new EnumMap<ModificationType, MedSavantWorker<Void>>(ModificationType.class);

        private EventFiringTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CacheController.this.timerLock;
            synchronized (object) {
                for (Map.Entry e : CacheController.this.timers.entrySet()) {
                    Long currentTime;
                    final ModificationType type = (ModificationType)((Object)e.getKey());
                    Long scheduledTime = (Long)e.getValue();
                    if (scheduledTime == null || (currentTime = Long.valueOf(System.currentTimeMillis())) < scheduledTime) continue;
                    MedSavantWorker<Void> worker = this.threadMap.get((Object)type);
                    if (worker != null && !worker.isDone() && !worker.isCancelled()) {
                        CacheController.this.timers.put(type, currentTime - 1L);
                    } else {
                        worker = new MedSavantWorker<Void>("CACHE " + (Object)((Object)type)){

                            @Override
                            protected Void doInBackground() throws Exception {
                                CacheController.this.fireEvent(type);
                                return null;
                            }

                            @Override
                            protected void showSuccess(Void result) {
                            }
                        };
                        this.threadMap.put(type, worker);
                        worker.execute();
                    }
                    CacheController.this.timers.put(type, currentTime + periodic_update_interval);
                }
            }
        }
    }
}

