/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.DownloadEvent;
import org.ut.biolab.medsavant.client.util.DownloadMonitor;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.serverapi.NetworkManagerAdapter;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;

public class ClientNetworkUtils
extends NetworkUtils {
    private static ExecutorService executor = Executors.newCachedThreadPool();

    public static void downloadFile(final URL u, final File destDir, final String fileName, final DownloadMonitor monitor) {
        new Thread("NetworkUtils.downloadFile"){
            double totalBytes;

            @Override
            public void run() {
                try {
                    int bytesRead;
                    HttpURLConnection httpConn = (HttpURLConnection)u.openConnection();
                    this.totalBytes = httpConn.getContentLength();
                    File destFile = new File(destDir, fileName != null ? fileName : ClientMiscUtils.getFilenameFromPath(u.getPath()));
                    FileOutputStream out = new FileOutputStream(destFile);
                    InputStream in = NetworkUtils.openStream(u);
                    ClientNetworkUtils.fireDownloadEvent(monitor, new DownloadEvent(DownloadEvent.Type.STARTED));
                    byte[] buf = new byte[8192];
                    long bytesSoFar = 0L;
                    while ((bytesRead = in.read(buf)) != -1 && !monitor.isCancelled()) {
                        ((OutputStream)out).write(buf, 0, bytesRead);
                        if (!(this.totalBytes > 0.0)) continue;
                        monitor.handleEvent(new DownloadEvent((double)(bytesSoFar += (long)bytesRead) / this.totalBytes));
                    }
                    ClientNetworkUtils.fireDownloadEvent(monitor, new DownloadEvent(destFile));
                }
                catch (IOException x) {
                    ClientNetworkUtils.fireDownloadEvent(monitor, new DownloadEvent(x));
                }
            }
        }.start();
    }

    private static void fireDownloadEvent(final Listener<DownloadEvent> listener, final DownloadEvent e) {
        ClientMiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                listener.handleEvent(e);
            }
        });
    }

    public static int copyFileToServer(File file) throws ExecutionException, InterruptedException {
        return ClientNetworkUtils.copyFileToServer(file, null).get();
    }

    public static Future<Integer> copyFileToServer(final File file, final Listener<DownloadEvent> listener) {
        return executor.submit(new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                NetworkManagerAdapter netMgr = MedSavantClient.NetworkManager;
                int streamID = -1;
                FileInputStream stream = null;
                try {
                    int numBytes;
                    stream = new FileInputStream(file);
                    streamID = netMgr.openWriterOnServer(LoginController.getSessionID(), file.getName(), ((InputStream)stream).available());
                    long totalBytes = ((InputStream)stream).available();
                    int bytesRead = 0;
                    byte[] buf = null;
                    while ((numBytes = Math.min(((InputStream)stream).available(), 65536)) > 0) {
                        if (buf == null || numBytes != buf.length) {
                            buf = new byte[numBytes];
                        }
                        bytesRead += ((InputStream)stream).read(buf);
                        netMgr.writeToServer(LoginController.getSessionID(), streamID, buf);
                        if (listener == null) continue;
                        listener.handleEvent(new DownloadEvent((double)bytesRead / (double)totalBytes));
                    }
                }
                finally {
                    if (streamID >= 0) {
                        netMgr.closeWriterOnServer(LoginController.getSessionID(), streamID);
                    }
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                return streamID;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFileFromServer(int streamID, File destFile) throws IOException, InterruptedException {
        NetworkManagerAdapter netMgr = MedSavantClient.NetworkManager;
        FileOutputStream stream = null;
        try {
            byte[] buf;
            stream = new FileOutputStream(destFile);
            while ((buf = netMgr.readFromServer(LoginController.getSessionID(), streamID)) != null) {
                ((OutputStream)stream).write(buf);
                stream.flush();
            }
        }
        finally {
            netMgr.closeReaderOnServer(LoginController.getSessionID(), streamID);
            if (stream != null) {
                ((OutputStream)stream).close();
            }
        }
    }
}

