/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;

public abstract class Controller<E> {
    private static final Log LOG = LogFactory.getLog(Controller.class);
    protected List<Listener<E>> listeners = new ArrayList<Listener<E>>();
    private List<Listener<E>> listenersToAdd;
    private List<Listener<E>> listenersToRemove;
    private boolean looping;

    public synchronized void fireEvent(E event) {
        this.listenersToAdd = new ArrayList<Listener<E>>();
        this.listenersToRemove = new ArrayList<Listener<E>>();
        this.looping = true;
        for (Listener<E> l : this.listeners) {
            try {
                l.handleEvent(event);
            }
            catch (Throwable ex) {
                LOG.warn((Object)String.format("%s threw exception while handling event.", l), ex);
            }
        }
        this.looping = false;
        for (Listener<E> l : this.listenersToAdd) {
            this.listeners.add(l);
        }
        this.listenersToAdd = null;
        for (Listener<E> l : this.listenersToRemove) {
            this.listeners.remove(l);
        }
        this.listenersToRemove = null;
    }

    public void addListener(Listener<E> l) {
        if (this.looping) {
            this.listenersToAdd.add(l);
        } else {
            this.listeners.add(l);
        }
    }

    public void removeListener(Listener<E> l) {
        if (this.looping) {
            this.listenersToRemove.add(l);
        } else {
            this.listeners.remove(l);
        }
    }
}

