/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.swing.JTable;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.util.ExtensionFileFilter;

public class ExportTable {
    public static void exportTable(JTable table) throws FileNotFoundException, IOException {
        File out = DialogUtils.chooseFileForSave("Export Table", "table_export", ExtensionFileFilter.createFilters(new String[]{"xls", "xlsx", "csv"}), null);
        if (out == null) {
            return;
        }
        String extension = ClientMiscUtils.getExtension(out.getAbsolutePath());
        if (extension.equals("xls") || extension.equals("xlsx")) {
            ExportTable.exportExcel(out, table);
        } else {
            ExportTable.exportCSV(out, table);
        }
    }

    private static void exportExcel(File file, JTable table) throws FileNotFoundException, IOException {
        Object wb = file.getAbsolutePath().endsWith(".xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        Row header = sheet.createRow(0);
        for (int j = 0; j < table.getColumnCount(); ++j) {
            header.createCell(j).setCellValue(table.getColumnName(j));
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            Row row = sheet.createRow(i + 1);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                row.createCell(j).setCellValue(ExportTable.getString(table.getValueAt(i, j)));
            }
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    private static void exportCSV(File file, JTable table) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));
        CSVWriter out = new CSVWriter((Writer)writer, ',', '\"');
        String[] header = new String[table.getColumnCount()];
        for (int j = 0; j < table.getColumnCount(); ++j) {
            header[j] = table.getColumnName(j);
        }
        out.writeNext(header);
        for (int i = 0; i < table.getRowCount(); ++i) {
            String[] row = new String[table.getColumnCount()];
            for (int j = 0; j < table.getColumnCount(); ++j) {
                row[j] = ExportTable.getString(table.getValueAt(i, j));
            }
            out.writeNext(row);
        }
        out.close();
        writer.close();
    }

    private static String getString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }
}

