/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.animation;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.ut.biolab.medsavant.client.view.animation.AnimatablePanel;
import org.ut.biolab.medsavant.client.view.animation.Animation;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public final class NotificationAnimation
extends Animation {
    private String message;
    private Position position = null;
    private static final Position DEFAULT_POSITION = Position.TOP_CENTER;
    private static final int MIN_DISTANCE_FROM_PANELEDGE = 55;
    private static final int DEFAULT_STAYTIME = 6000;
    private static final int DEFAULT_FADETIME = 2000;
    private static final int AUTO_HEIGHT = -1;
    private static final int ROUNDRECT_ARCWIDTH = 0;
    private static final int ROUNDRECT_ARCHEIGHT = 0;
    private int margin_x = 10;
    private int margin_y = 10;
    private int x;
    private int y;
    private int width;
    private int height = -1;
    private final int containingPanelWidth;
    private final int containingPanelHeight;
    private long stayTime = 6000L;
    private long fadeTime = 2000L;
    private float initial_alpha;
    private float alpha = this.initial_alpha = 0.8f;
    private float textalpha = 1.0f;
    private Font font = ViewUtil.detailFontPlain.deriveFont(10);

    public NotificationAnimation(long stayTime, long fadeTime, String message, JPanel containingPanel, Position pos) {
        super(stayTime + fadeTime);
        this.stayTime = stayTime;
        this.fadeTime = fadeTime;
        this.message = message;
        this.containingPanelWidth = containingPanel.getWidth();
        this.containingPanelHeight = containingPanel.getHeight();
        this.setDimensions(this.containingPanelWidth, -1);
        this.setPosition(pos);
    }

    public NotificationAnimation(String msg, JPanel containingPanel, Position pos) {
        this(6000L, 2000L, msg, containingPanel, pos);
    }

    public NotificationAnimation(String msg, JPanel containingPanel) {
        this(6000L, 2000L, msg, containingPanel, DEFAULT_POSITION);
    }

    public NotificationAnimation setFont(Font font) {
        this.font = font;
        return this;
    }

    public NotificationAnimation setMargins(int marginx, int marginy) {
        this.margin_x = marginx;
        this.margin_y = marginy;
        return this;
    }

    public NotificationAnimation setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public NotificationAnimation setPosition(int x, int y) {
        this.position = null;
        this.x = x;
        this.y = y;
        return this;
    }

    public NotificationAnimation setPosition(Position pos) {
        this.position = pos;
        return this;
    }

    private void updateCoordsFromPosition() {
        switch (this.position) {
            case TOP_RIGHT: {
                this.x = this.containingPanelWidth - this.width - 55;
                this.y = 55;
                break;
            }
            case TOP_LEFT: {
                this.x = 55;
                this.y = 55;
                break;
            }
            case TOP_CENTER: {
                this.x = (int)Math.round((double)this.containingPanelWidth / 2.0 - (double)this.width / 2.0);
                this.y = 55;
                break;
            }
            case BOTTOM_LEFT: {
                this.x = 55;
                this.y = this.containingPanelHeight - this.height - 55;
                break;
            }
            case BOTTOM_CENTER: {
                this.x = (int)Math.round((double)this.containingPanelWidth / 2.0 - (double)this.width / 2.0);
                this.y = this.containingPanelHeight - this.height - 55;
                break;
            }
            case BOTTOM_RIGHT: {
                this.x = this.containingPanelWidth - this.width - 55;
                this.y = this.containingPanelHeight - this.height - 55;
            }
        }
    }

    public NotificationAnimation setMessage(String message) {
        this.message = message;
        return this;
    }

    public NotificationAnimation setInitialAlpha(float alpha) {
        this.alpha = this.initial_alpha = alpha;
        return this;
    }

    private int drawString(Graphics2D g2d, String msg, boolean draw) {
        String[] words;
        int msg_x;
        Font f = UIManager.getFont("Label.font").deriveFont(1, 13.0f);
        g2d.setFont(f);
        FontMetrics fm = g2d.getFontMetrics();
        int lineHeight = fm.getHeight();
        int curX = msg_x = this.x + this.margin_x;
        int curY = this.y + this.margin_y + fm.getAscent();
        int msg_width = this.width - 2 * this.margin_x;
        g2d.setColor(new Color(49, 112, 143));
        for (String word : words = msg.split(" ")) {
            int wordWidth = fm.stringWidth(word + " ");
            if (curX + wordWidth >= msg_x + msg_width) {
                curY += lineHeight;
                curX = msg_x;
            }
            if (draw) {
                g2d.drawString(word, curX, curY);
            }
            curX += wordWidth;
        }
        return curY + fm.getDescent() + this.margin_y - this.y;
    }

    @Override
    public void drawUpdate(Graphics2D g2d, AnimatablePanel animatablePanel) {
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setFont(this.font);
        int w = this.width;
        int h = this.height;
        if (this.height == -1) {
            h = this.drawString(g2d, this.message, false);
        }
        if (this.position != null) {
            this.updateCoordsFromPosition();
        }
        g2d.setColor(new Color(217, 237, 247));
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.fillRoundRect(this.x, this.y, w, h, 0, 0);
        g2d.setColor(Color.WHITE);
        g2d.setComposite(AlphaComposite.getInstance(3, this.textalpha));
        this.drawString(g2d, this.message, true);
    }

    @Override
    public boolean tick(long runTime) {
        if (runTime > this.stayTime) {
            this.alpha = Math.max(0.0f, this.initial_alpha - (float)(runTime - this.stayTime) / (float)this.fadeTime);
            this.textalpha = (float)Math.max(0.0, 1.0 - (double)((float)(runTime - this.stayTime) / (float)this.fadeTime));
        }
        return runTime >= this.stayTime + this.fadeTime;
    }

    @Override
    public void done() {
    }

    public static enum Position {
        TOP_RIGHT,
        TOP_LEFT,
        TOP_CENTER,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

