/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin;

import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommHandler;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommRegistry;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.PatientVariantAnalyzeComm;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.commons.lang3.ArrayUtils;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.app.builtin.settings.PluginPage;
import org.ut.biolab.medsavant.client.view.genetics.GeneticsChartPage;
import org.ut.biolab.medsavant.client.view.genetics.GeneticsFilterPage;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.genetics.SpreadsheetPage;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.shared.appapi.MedSavantApp;
import org.ut.biolab.medsavant.shared.appapi.MedSavantVariantSectionApp;

public class VariantNavigatorApp
extends MultiSectionApp
implements AppCommHandler<PatientVariantAnalyzeComm> {
    public static boolean isInitialized = false;
    private JPanel[] persistencePanels;

    public VariantNavigatorApp() {
        super("Variant Navigator");
        this.getSectionMenuComponents();
        AppCommRegistry.getInstance().registerHandler((AppCommHandler)this, PatientVariantAnalyzeComm.class);
    }

    @Override
    public ImageIcon getIcon() {
        return IconFactory.getInstance().getIcon(IconFactory.StandardIcon.APP_VARIANTNAVIGATOR);
    }

    @Override
    public final Component[] getSectionMenuComponents() {
        isInitialized = true;
        return new Component[0];
    }

    @Override
    public AppSubSection[] getSubSections() {
        LinkedList<PluginPage> appSections = new LinkedList<PluginPage>();
        List<MedSavantApp> variantSectionApps = AppController.getInstance().getPluginsOfClass(MedSavantVariantSectionApp.class);
        int numApps = variantSectionApps.size();
        for (MedSavantApp app : variantSectionApps) {
            appSections.add(new PluginPage((MultiSectionApp)this, (MedSavantVariantSectionApp)app));
        }
        Object[] builtInSections = new AppSubSection[]{new SpreadsheetPage(this), new GeneticsChartPage(this)};
        return (AppSubSection[])ArrayUtils.addAll((Object[])builtInSections, (Object[])appSections.toArray(new AppSubSection[numApps]));
    }

    @Override
    public JPanel[] getPersistentPanels() {
        if (this.persistencePanels == null) {
            this.persistencePanels = new JPanel[]{new GeneticsFilterPage(this).getView()};
        }
        return this.persistencePanels;
    }

    public String getHandlerName() {
        return this.getName();
    }

    public ImageIcon getHandlerIcon() {
        return this.getIcon();
    }

    public void handleCommEvent(PatientVariantAnalyzeComm value) {
        Integer patientID = (Integer)value.getEventData();
        MedSavantFrame.getInstance().getDashboard().launchApp(this);
        QueryUtils.addQueryOnPatients(new int[]{patientID});
        MedSavantFrame.getInstance().repaint();
    }
}

