/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin.settings;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.util.DataRetriever;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.SearchableTablePanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.GeneralLog;

public class ServerLogPage
extends AppSubSection {
    private static final Log LOG = LogFactory.getLog(ServerLogPage.class);
    private static final String CARDNAME_WAIT = "0";
    private static final String CARDNAME_SERVER = "1";
    private static final String[] CLIENT_COLUMN_NAMES = new String[]{"User", "Type", "Description", "Time"};
    private static final Class[] CLIENT_COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class};
    private static final String[] ANNOTATIONS_COLUMN_NAMES = new String[]{"Project", "Reference", "Action", "Status", "Time", "User"};
    private static final Class[] ANNOTATIONS_COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
    private boolean clientTableRefreshed = false;
    private boolean serverTableRefreshed = false;
    private boolean annotationTableRefreshed = false;
    private String currentCard;
    private JPanel view;
    private JPanel menuPanel;
    private JPanel listPanel;
    private SearchableTablePanel clientTable;
    private SearchableTablePanel serverTable;
    private SearchableTablePanel annotationTable;
    private WaitPanel waitPanel;
    private int limit = 1000;

    public ServerLogPage(MultiSectionApp parent) {
        super(parent, "Logs");
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new JPanel();
            this.view.setLayout(new BorderLayout());
            this.menuPanel = new JPanel();
            ViewUtil.applyHorizontalBoxLayout(this.menuPanel);
            this.listPanel = new JPanel();
            this.listPanel.setLayout(new CardLayout());
            this.listPanel.add((Component)this.getWaitPanel(), CARDNAME_WAIT);
            this.listPanel.add((Component)this.getClientCard(), CARDNAME_SERVER);
            this.view.add((Component)this.menuPanel, "North");
            this.view.add((Component)this.listPanel, "Center");
            this.changeToCard(CARDNAME_SERVER);
            JButton refreshButton = new JButton("Refresh");
            refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ServerLogPage.this.refreshCurrentCard();
                }
            });
            this.menuPanel.add(Box.createHorizontalGlue());
            this.menuPanel.add(refreshButton);
            this.menuPanel.add(Box.createHorizontalGlue());
        }
        return this.view;
    }

    private void refreshCurrentCard() {
        this.refreshClientCard();
    }

    private synchronized void changeToCard(String cardname) {
        CardLayout cl = (CardLayout)this.listPanel.getLayout();
        cl.show(this.listPanel, cardname);
        this.currentCard = cardname;
        if (cardname.equals(CARDNAME_SERVER) && !this.clientTableRefreshed) {
            this.refreshClientCard();
            this.clientTableRefreshed = true;
        }
    }

    private synchronized void showWaitPanel() {
        CardLayout cl = (CardLayout)this.listPanel.getLayout();
        cl.show(this.listPanel, CARDNAME_WAIT);
    }

    private synchronized void hideWaitPanel() {
        CardLayout cl = (CardLayout)this.listPanel.getLayout();
        cl.show(this.listPanel, this.currentCard);
    }

    private JPanel getClientCard() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        DataRetriever retriever = new DataRetriever(){

            public List<Object[]> retrieve(int start, int limit) {
                return ServerLogPage.this.retrieveClientData(start, limit);
            }

            @Override
            public int getTotalNum() {
                try {
                    return MedSavantClient.LogManager.getServerLogSize(LoginController.getSessionID());
                }
                catch (Exception ex) {
                    return 0;
                }
            }

            @Override
            public void retrievalComplete() {
            }
        };
        this.clientTable = new SearchableTablePanel(this.pageName, CLIENT_COLUMN_NAMES, CLIENT_COLUMN_CLASSES, new int[0], this.limit, retriever);
        this.clientTable.setChooseColumnsButtonVisible(false);
        this.clientTable.setExportButtonVisible(false);
        p.add((Component)this.clientTable, "Center");
        return p;
    }

    private void refreshClientCard() {
        this.clientTable.forceRefreshData();
    }

    @Override
    public Component[] getSubSectionMenuComponents() {
        return null;
    }

    private WaitPanel getWaitPanel() {
        this.waitPanel = new WaitPanel("Getting log...");
        return this.waitPanel;
    }

    private List<Object[]> retrieveClientData(int start, int limit) {
        ArrayList<Object[]> v = null;
        this.waitPanel.setIndeterminate();
        this.waitPanel.setStatus("");
        this.showWaitPanel();
        try {
            List<GeneralLog> logs = MedSavantClient.LogManager.getServerLog(LoginController.getSessionID(), start, limit);
            v = new ArrayList<Object[]>();
            for (GeneralLog log : logs) {
                v.add(new Object[]{log.getUser(), log.getEvent(), log.getDescription(), log.getTimestamp()});
            }
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
        }
        catch (Exception ex) {
            this.waitPanel.setComplete();
            this.waitPanel.setStatus("Problem getting log");
            this.showWaitPanel();
            LOG.error((Object)"Error retrieving client log.", (Throwable)ex);
        }
        this.hideWaitPanel();
        return v;
    }
}

