/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin.task;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.app.builtin.task.TaskWorker;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.GeneralLog;
import org.ut.biolab.medsavant.shared.model.MedSavantServerJobProgress;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class ServerJobMonitorTaskWorker
implements TaskWorker {
    private boolean stop = false;

    @Override
    public String getTaskName() {
        return "Server Job Monitor";
    }

    @Override
    public TaskWorker.TaskStatus getCurrentStatus() {
        if (this.stop) {
            return TaskWorker.TaskStatus.FINISHED;
        }
        return TaskWorker.TaskStatus.PERSISTENT_AUTOREFRESH;
    }

    private List<GeneralLog> getSortedChildren(List<MedSavantServerJobProgress> mjps, int level) {
        LinkedList<GeneralLog> output = new LinkedList<GeneralLog>();
        TreeMap<Integer, LinkedList<MedSavantServerJobProgress>> m = new TreeMap<Integer, LinkedList<MedSavantServerJobProgress>>();
        for (MedSavantServerJobProgress p : mjps) {
            LinkedList<MedSavantServerJobProgress> l = (LinkedList<MedSavantServerJobProgress>)m.get(p.getStatus().ordinal());
            if (l == null) {
                l = new LinkedList<MedSavantServerJobProgress>();
            }
            l.add(p);
            m.put(p.getStatus().ordinal(), l);
        }
        String tabStr = StringUtils.repeat((String)"     ", (int)level);
        int jid = 0;
        for (List mjpList : m.values()) {
            for (MedSavantServerJobProgress mjp : mjpList) {
                String msg = mjp.getMessage();
                msg = msg == null ? "" : " - " + msg;
                output.add(new GeneralLog(null, tabStr + "(" + (Object)((Object)mjp.getStatus()) + ") " + jid + ". " + mjp.getJobName() + msg, null));
                if (mjp.childJobProgresses != null && !mjp.childJobProgresses.isEmpty()) {
                    output.addAll(this.getSortedChildren(mjp.childJobProgresses, level + 1));
                }
                ++jid;
            }
        }
        return output;
    }

    private List<GeneralLog> logout(SessionExpiredException see) {
        ArrayList<GeneralLog> nl = new ArrayList<GeneralLog>(1);
        nl.add(new GeneralLog("Session Expired - please quit and login again"));
        MedSavantExceptionHandler.handleSessionExpiredException(see);
        return nl;
    }

    @Override
    public List<GeneralLog> getLog() {
        if (this.stop) {
            return new ArrayList<GeneralLog>();
        }
        String sessionId = LoginController.getSessionID();
        try {
            List<MedSavantServerJobProgress> mjps = MedSavantClient.LogManager.getJobProgressForUserWithSessionID(sessionId);
            if (mjps == null) {
                return new ArrayList<GeneralLog>(1);
            }
            return this.getSortedChildren(mjps, 0);
        }
        catch (SessionExpiredException see) {
            this.stop = true;
            return this.logout(see);
        }
        catch (Exception ex) {
            this.stop = true;
            try {
                MedSavantClient.SessionManager.testConnection(sessionId);
            }
            catch (SessionExpiredException see) {
                return this.logout(see);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String s = "Error retrieving task information";
            ArrayList<GeneralLog> r = new ArrayList<GeneralLog>(1);
            r.add(new GeneralLog(null, s, null));
            Logger.getLogger(ServerJobMonitorTaskWorker.class.getName()).log(Level.SEVERE, null, ex);
            return r;
        }
    }

    @Override
    public double getTaskProgress() {
        return 0.0;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addListener(Listener<TaskWorker> w) {
    }

    @Override
    public LaunchableApp getOwner() {
        return null;
    }
}

