/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import com.jidesoft.swing.RangeSlider;

public class DecimalRangeSlider
extends RangeSlider {
    private int multiplier;

    public DecimalRangeSlider(int precision) {
        this.setPrecision(precision);
    }

    public final void setPrecision(int precision) {
        this.multiplier = precision <= 0 ? 1 : precision * 10;
    }

    public DecimalRangeSlider() {
        this(0);
    }

    public void setMinimum(int i) {
        super.setMinimum(this.adjustValue(i));
    }

    public void setMaximum(int i) {
        super.setMaximum(this.adjustValue(i));
    }

    public void setLow(double i) {
        super.setLowValue(this.adjustValue(i));
    }

    public void setHigh(double i) {
        super.setHighValue(this.adjustValue(i));
    }

    public double getLow() {
        int value = super.getLowValue();
        return this.getActualValue(value);
    }

    public double getHigh() {
        int value = super.getHighValue();
        return this.getActualValue(value);
    }

    private int adjustValue(double i) {
        return (int)(i * (double)this.multiplier);
    }

    private int adjustValue(int i) {
        return i * this.multiplier;
    }

    private double getActualValue(int i) {
        return (double)i / (double)this.multiplier;
    }
}

