/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class HeroPanel
extends JPanel {
    private HeroUnit heroUnit;
    private JPanel contentUnit;

    public HeroPanel() {
        this.initView();
    }

    private void initView() {
        this.setBackground(ViewUtil.getDefaultBackgroundColor());
        this.heroUnit = new HeroUnit();
        this.contentUnit = ViewUtil.getClearPanel();
        this.contentUnit.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.heroUnit, "North");
        this.add((Component)this.contentUnit, "Center");
    }

    public void setContent(JPanel p) {
        this.contentUnit.removeAll();
        this.contentUnit.add((Component)p, "Center");
    }

    public HeroUnit getHeroUnit() {
        return this.heroUnit;
    }

    public static class HeroUnit
    extends JPanel {
        private JLabel heroLabel;
        private Image backgroundImage;

        public HeroUnit() {
            this.initView();
        }

        private void initView() {
            this.setLayout((LayoutManager)new MigLayout("hmin 100, filly, insets 30 50 30 50"));
            this.heroLabel = ViewUtil.getLargeGrayLabel("");
            this.add(this.heroLabel);
        }

        public void setHeroTitle(String title) {
            this.heroLabel.setText(title);
        }

        @Override
        public void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(ViewUtil.getLightGrayBackgroundColor());
            g.fillRect(0, 0, width, height);
            if (this.backgroundImage != null) {
                BufferedImage resizedImage = new BufferedImage(width, height, 2);
                Graphics2D g2 = resizedImage.createGraphics();
                g.drawImage(this.backgroundImage, 0, 0, null);
            }
        }
    }
}

