/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.view.font.FontFactory;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class KeyValuePairPanel
extends JPanel {
    public static final String NULL_VALUE = "<NONE>";
    public static final Font KEY_FONT = FontFactory.getGeneralFont().deriveFont(11.0f).deriveFont(1);
    private Map<String, JLabel> keyKeyComponentMap;
    private Map<String, JPanel> keyValueComponentMap;
    private Map<String, JPanel> keyDetailComponentMap;
    private final Map<String, JPanel[]> keyExtraComponentsMap;
    private final int additionalColumns;
    private final ArrayList<GridBagConstraints> columnConstraints;
    private boolean showingMore = false;
    private List<String> keysInMoreSection;
    private boolean newRowsGoIntoMoreSection;
    private final GridBagConstraints keyDetailConstraints;
    private JPanel kvpPanel;
    private JPanel toolbar;
    private boolean keysVisible = true;
    private static final Log LOG = LogFactory.getLog(KeyValuePairPanel.class);

    public KeyValuePairPanel() {
        this(0);
    }

    public KeyValuePairPanel(int additionalColumns) {
        this(additionalColumns, false);
    }

    public KeyValuePairPanel(int addCols, boolean widelist) {
        this.setOpaque(false);
        ViewUtil.applyVerticalBoxLayout(this);
        this.kvpPanel = ViewUtil.getClearPanel();
        this.toolbar = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(this.toolbar);
        this.add(this.kvpPanel);
        this.add(this.toolbar);
        this.additionalColumns = addCols;
        this.keyKeyComponentMap = new HashMap<String, JLabel>();
        this.keyValueComponentMap = new HashMap<String, JPanel>();
        this.keyDetailComponentMap = new HashMap<String, JPanel>();
        this.keyExtraComponentsMap = new HashMap<String, JPanel[]>();
        this.columnConstraints = new ArrayList();
        this.keysInMoreSection = new ArrayList<String>();
        this.keyDetailConstraints = new GridBagConstraints();
        this.keyDetailConstraints.anchor = 16;
        this.keyDetailConstraints.weightx = 1.0;
        this.keyDetailConstraints.fill = 1;
        this.keyDetailConstraints.gridx = 0;
        this.keyDetailConstraints.gridy = 0;
        this.keyDetailConstraints.gridwidth = 0;
        GridBagConstraints keyConstraints = new GridBagConstraints();
        keyConstraints.anchor = 16;
        keyConstraints.fill = 1;
        keyConstraints.weightx = 0.0;
        keyConstraints.gridx = 0;
        keyConstraints.gridy = 0;
        keyConstraints.ipadx = 5;
        GridBagConstraints valueConstraints = new GridBagConstraints();
        valueConstraints.anchor = 16;
        valueConstraints.fill = 1;
        valueConstraints.weightx = widelist ? 0.0 : 1.0;
        valueConstraints.gridx = 1;
        valueConstraints.gridy = 0;
        valueConstraints.ipadx = 5;
        this.columnConstraints.add(keyConstraints);
        this.columnConstraints.add(valueConstraints);
        for (int i = 0; i < this.additionalColumns; ++i) {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 1;
            c.weightx = widelist ? (double)(i == this.additionalColumns - 1 ? 1 : 0) : 0.0;
            c.gridx = i + this.columnConstraints.size();
            c.gridy = 0;
            this.columnConstraints.add(c);
        }
        GridBagLayout gbl = new GridBagLayout();
        this.kvpPanel.setLayout(gbl);
    }

    public void setXPadding(int padx) {
        this.columnConstraints.get((int)0).ipadx = padx;
        this.columnConstraints.get((int)1).ipadx = padx;
    }

    public void setYPadding(int pady) {
        this.columnConstraints.get((int)0).ipady = pady;
        this.columnConstraints.get((int)1).ipady = pady;
    }

    public static JLabel getKeyLabel(String s) {
        JLabel l = new JLabel(s);
        l.setFont(KEY_FONT);
        return l;
    }

    public JComponent getComponent(String key) {
        JPanel valuePanel = this.keyValueComponentMap.get(key);
        if (valuePanel.getComponentCount() > 0) {
            return (JComponent)valuePanel.getComponent(0);
        }
        return null;
    }

    public String getValue(String key) {
        JComponent c = this.getComponent(key);
        if (c instanceof JLabel) {
            return ((JLabel)c).getToolTipText();
        }
        LOG.warn((Object)"WARNING: accessing string value of non-string label");
        return c.toString();
    }

    public void addMoreRow() {
        final JToggleButton b = ViewUtil.getSoftToggleButton("MORE");
        ViewUtil.makeMini(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                KeyValuePairPanel.this.toggleMoreVisibility();
                if (b.getText().equals("MORE")) {
                    b.setText("LESS");
                } else {
                    b.setText("MORE");
                }
            }
        });
        this.toolbar.add(ViewUtil.getCenterAlignedComponent(b));
        this.newRowsGoIntoMoreSection = true;
    }

    public void setKeysVisible(boolean b) {
        this.keysVisible = b;
        this.resetKeyVisibility();
    }

    private void resetKeyVisibility() {
        for (String key : this.keyKeyComponentMap.keySet()) {
            this.keyKeyComponentMap.get(key).setVisible(this.keysVisible);
        }
    }

    public void toggleMoreVisibility() {
        this.setMoreVisibility(!this.showingMore);
    }

    private void setMoreVisibility(boolean b) {
        this.showingMore = b;
        for (String key : this.keysInMoreSection) {
            this.keyKeyComponentMap.get(key).setVisible(b && this.keysVisible);
            this.keyValueComponentMap.get(key).setVisible(b);
            for (JPanel c : this.keyExtraComponentsMap.get(key)) {
                c.setVisible(b);
            }
            if (b || !this.keyDetailComponentMap.get(key).isVisible()) continue;
            this.keyDetailComponentMap.get(key).setVisible(false);
        }
    }

    public void addKey(String key) {
        this.addKey(key, false);
    }

    public void addKeyWithValue(String key, String value) {
        this.addKey(key);
        this.setValue(key, value);
    }

    public void addKeyWithValue(String key, JComponent value) {
        this.addKey(key);
        this.setValue(key, value);
    }

    public void addKey(final String key, boolean showExpand) {
        Color rowColor = Color.WHITE;
        if (this.keyKeyComponentMap.size() % 2 == 0) {
            rowColor = ViewUtil.getAlternateRowColor();
        }
        if (this.newRowsGoIntoMoreSection) {
            this.keysInMoreSection.add(key);
        }
        rowColor = Color.white;
        String layoutConstraints = "insets 3 3 3 3, filly";
        JPanel valuePanel = ViewUtil.getClearPanel();
        valuePanel.setLayout((LayoutManager)new MigLayout(layoutConstraints));
        valuePanel.setBackground(rowColor);
        int i = 0;
        JPanel keyPanel = ViewUtil.getClearPanel();
        keyPanel.setLayout((LayoutManager)new MigLayout(layoutConstraints + ", alignx right, hmin 30"));
        keyPanel.setBackground(rowColor);
        final JLabel keyLabel = KeyValuePairPanel.getKeyLabel(key);
        this.keyKeyComponentMap.put(key, keyLabel);
        if (showExpand) {
            keyLabel.setText("? " + key.toUpperCase());
            keyLabel.setCursor(new Cursor(12));
            keyLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    KeyValuePairPanel.this.toggleMoreVisibility();
                    if (keyLabel.getText().startsWith("?")) {
                        keyLabel.setText("? " + key.toUpperCase());
                    } else {
                        keyLabel.setText("? " + key.toUpperCase());
                    }
                }
            });
        }
        keyPanel.add(keyLabel);
        keyLabel.setVisible(this.keysVisible);
        this.kvpPanel.add((Component)keyPanel, this.incrementConstraintRow(i++));
        this.kvpPanel.add((Component)valuePanel, this.incrementConstraintRow(i++));
        JPanel[] extraComponents = new JPanel[this.additionalColumns];
        for (int j = 0; j < this.additionalColumns; ++j) {
            JPanel panel = ViewUtil.getClearPanel();
            panel.setBackground(rowColor);
            ViewUtil.applyHorizontalBoxLayout(panel);
            extraComponents[j] = panel;
            this.kvpPanel.add((Component)extraComponents[j], this.incrementConstraintRow(i++));
        }
        ++this.keyDetailConstraints.gridy;
        ++this.keyDetailConstraints.gridy;
        JPanel detailPanel = ViewUtil.getClearPanel();
        detailPanel.setBackground(rowColor);
        detailPanel.setVisible(false);
        this.keyDetailComponentMap.put(key, detailPanel);
        this.kvpPanel.add((Component)detailPanel, this.keyDetailConstraints);
        for (int k = 0; k < 2 + this.additionalColumns; ++k) {
            this.incrementConstraintRow(k);
        }
        this.keyValueComponentMap.put(key, valuePanel);
        this.keyExtraComponentsMap.put(key, extraComponents);
        this.setMoreVisibility(this.showingMore);
    }

    public void setValue(String key, JComponent value) {
        JPanel p = this.keyValueComponentMap.get(key);
        p.removeAll();
        p.add(value);
        p.add(Box.createHorizontalGlue());
        p.repaint();
        p.getParent().repaint();
    }

    public void setValue(String key, String value) {
        this.setValue(key, value, false);
    }

    public void setValue(String key, String value, boolean splitCommas) {
        if (value == null || value.equals(NULL_VALUE)) {
            this.setValue(key, this.getNullLabel());
            return;
        }
        if (splitCommas && (value.indexOf(44) > 0 || value.indexOf(59) > 0)) {
            value = "<html>" + value.replace(",", "<br/>").replace(";", "<br/>") + "</html>";
        }
        JLabel c = new JLabel(value);
        if (splitCommas) {
            c.setToolTipText(value);
        }
        this.setValue(key, c);
    }

    public void setToolTipForValue(String key, String toolTipText) {
        if (this.keysVisible) {
            this.keyKeyComponentMap.get(key).setToolTipText(toolTipText);
        } else {
            this.keyValueComponentMap.get(key).setToolTipText(toolTipText);
        }
    }

    private JLabel getNullLabel() {
        JLabel l = new JLabel("NULL");
        l.setForeground(Color.red);
        ViewUtil.makeSmall(l);
        return l;
    }

    public void setAdditionalColumn(String key, int additionalColumnIndex, Component c) {
        this.keyExtraComponentsMap.get(key)[additionalColumnIndex].removeAll();
        this.keyExtraComponentsMap.get(key)[additionalColumnIndex].add(c);
    }

    public GridBagConstraints incrementConstraintRow(int col) {
        GridBagConstraints c = this.columnConstraints.get(col);
        ++c.gridy;
        return c;
    }

    public void toggleDetailVisibility(String key) {
        JPanel p = this.keyDetailComponentMap.get(key);
        this.toggleDetailVisibility(key, !p.isVisible());
    }

    public void toggleDetailVisibility(String key, boolean visible) {
        JPanel p = this.keyDetailComponentMap.get(key);
        p.setVisible(visible);
    }

    public void setDetailComponent(String key, JComponent c) {
        JPanel p = this.keyDetailComponentMap.get(key);
        p.removeAll();
        p.setLayout(new BorderLayout());
        p.add((Component)c, "Center");
    }

    public void setKeyColour(String keyName, Color c) {
        this.keyKeyComponentMap.get(keyName).setForeground(c);
    }

    public void removeBottomRow(String key) {
        if (this.keysVisible) {
            this.kvpPanel.remove(this.keyKeyComponentMap.remove(key));
        }
        this.kvpPanel.remove(this.keyValueComponentMap.remove(key));
        for (JPanel j : this.keyExtraComponentsMap.remove(key)) {
            this.kvpPanel.remove(j);
        }
        this.kvpPanel.remove(this.keyDetailComponentMap.remove(key));
        for (GridBagConstraints c : this.columnConstraints) {
            --c.gridy;
        }
        --this.keyDetailConstraints.gridy;
        this.kvpPanel.invalidate();
        this.kvpPanel.updateUI();
    }

    public boolean containsKey(String key) {
        return this.keyKeyComponentMap.containsKey(key);
    }

    public JComponent getAdditionalColumn(String key, int index) {
        JPanel p = this.keyExtraComponentsMap.get(key)[index];
        if (p.getComponentCount() > 0) {
            return (JComponent)p.getComponent(0);
        }
        return null;
    }

    public static Component getCopyButton(final String key, final KeyValuePairPanel p) {
        JButton button = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.COPY));
        button.setToolTipText("Copy " + key);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String selection = p.getValue(key);
                StringSelection data = new StringSelection(selection);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, data);
                DialogUtils.displayMessage("Copied \"" + selection + "\" to clipboard.");
            }
        });
        return button;
    }

    public void simpleEllipsify() {
        for (String k : this.keyValueComponentMap.keySet()) {
            JComponent comp = this.getComponent(k);
            if (!(comp instanceof JLabel)) continue;
            JLabel l = (JLabel)comp;
            String s = l.getText();
            if (s.length() > 25) {
                s = s.substring(0, 20) + "...";
            }
            l.setText(s);
        }
    }

    public void ellipsifyValues(int width) {
        int maxKeyWidth = 0;
        int[] maxAdditionalColumnsWidth = new int[this.additionalColumns];
        for (JComponent jComponent : this.keyKeyComponentMap.values()) {
            maxKeyWidth = Math.max(maxKeyWidth, jComponent.getPreferredSize().width);
        }
        for (String string : this.keyValueComponentMap.keySet()) {
            for (int i = 0; i < this.additionalColumns; ++i) {
                JComponent extraComp = this.getAdditionalColumn(string, i);
                if (extraComp == null) continue;
                maxAdditionalColumnsWidth[i] = Math.max(maxAdditionalColumnsWidth[i], extraComp.getPreferredSize().width);
            }
        }
        width -= maxKeyWidth;
        for (int i : maxAdditionalColumnsWidth) {
            width -= i;
        }
        block4: for (String string : this.keyValueComponentMap.keySet()) {
            JComponent comp = this.getComponent(string);
            if (comp == null) continue;
            int avail = width;
            if (comp instanceof JLabel) {
                while (avail < comp.getPreferredSize().width) {
                    String text = ((JLabel)comp).getText();
                    if (text.endsWith("\u2026")) {
                        if (text.length() <= 2) continue block4;
                        text = text.substring(0, text.length() - 2);
                    } else {
                        int spacePos = text.lastIndexOf(32);
                        if (spacePos > 0) {
                            text = text.substring(0, spacePos);
                        } else {
                            FontMetrics fm = comp.getFontMetrics(comp.getFont());
                            while (fm.stringWidth(text + "\u2026") > avail) {
                                if (text == null || text.length() < 2) {
                                    LOG.info((Object)"Text is null or empty in KeyValuePairPanel");
                                    break;
                                }
                                text = text.substring(0, text.length() - 2);
                            }
                        }
                    }
                    ((JLabel)comp).setText(text + "\u2026");
                }
                continue;
            }
            comp.setMaximumSize(new Dimension(avail, comp.getPreferredSize().height));
        }
    }
}

