/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.AutoResizePopupMenuCustomizer;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapperUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.view.component.ColumnChooser;
import org.ut.biolab.medsavant.client.view.component.GenericTableModel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class ListViewTablePanel
extends JPanel {
    private static final Log LOG = LogFactory.getLog(ListViewTablePanel.class);
    private QuickTableFilterField filterField;
    private GenericTableModel model;
    private SortableTable table;
    private Object[][] data;
    private String[] columnNames;
    private Class[] columnClasses;
    private ColumnChooser columnChooser;
    private int[] hiddenColumns;
    private final JPanel fieldPanel;
    private float fontSize = 14.0f;
    protected Map<Object, Set<Integer>> keyRowIndexMap;
    private Color evenRowColor = ViewUtil.evenRowColor;
    private Color oddRowColor = ViewUtil.oddRowColor;

    public ListViewTablePanel setEvenRowColor(Color c) {
        this.evenRowColor = c;
        return this;
    }

    public ListViewTablePanel setOddRowColor(Color c) {
        this.oddRowColor = c;
        return this;
    }

    public ListViewTablePanel(Object[][] data, String[] columnNames, Class[] columnClasses, int[] hiddenColumns) {
        this(data, columnNames, columnClasses, hiddenColumns, true, true, true, true);
    }

    public ListViewTablePanel(Object[][] data, String[] columnNames, Class[] columnClasses, int[] hiddenColumns, boolean allowSearch, boolean allowSort, boolean allowPages, boolean allowSelection) {
        this.hiddenColumns = hiddenColumns;
        this.table = new SortableTable(){

            public Component prepareRenderer(TableCellRenderer renderer, int Index_row, int Index_col) {
                Component comp = super.prepareRenderer(renderer, Index_row, Index_col);
                if (this.isRowSelected(Index_row)) {
                    comp.setBackground(ViewUtil.detailSelectedBackground);
                } else if (Index_row % 2 == 0) {
                    comp.setBackground(ListViewTablePanel.this.evenRowColor);
                } else {
                    comp.setBackground(ListViewTablePanel.this.oddRowColor);
                }
                comp.setForeground(ViewUtil.detailForeground);
                comp.setFont(comp.getFont().deriveFont(ListViewTablePanel.this.fontSize));
                return comp;
            }
        };
        this.table.setBorder(null);
        this.table.setSelectionForeground(Color.darkGray);
        this.table.setRowHeight(30);
        this.table.setClearSelectionOnTableDataChanges(true);
        this.table.setOptimized(true);
        this.table.setColumnAutoResizable(true);
        this.table.setAutoResort(false);
        this.table.setSortable(allowSort);
        this.table.setSortingEnabled(allowSort);
        this.table.setFocusable(allowSelection);
        this.table.setCellSelectionEnabled(allowSelection);
        this.table.setSelectionMode(2);
        this.table.setAutoResizeMode(2);
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)this.table);
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new AutoResizePopupMenuCustomizer());
        this.columnChooser = new ColumnChooser((JTable)this.table);
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)this.columnChooser);
        AutoFilterTableHeader header = new AutoFilterTableHeader((JTable)this.table);
        header.setAutoFilterEnabled(true);
        header.setShowFilterIcon(true);
        header.setShowFilterName(true);
        this.table.setTableHeader((JTableHeader)header);
        this.filterField = new QuickTableFilterField((TableModel)((Object)this.model));
        this.filterField.setHintText("Type to search");
        this.setLayout(new BorderLayout(3, 3));
        this.fieldPanel = ViewUtil.getClearPanel();
        this.fieldPanel.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 1;
        if (allowSearch) {
            this.fieldPanel.add((Component)this.filterField, gbc);
        }
        if (columnNames.length > 1) {
            JButton chooseColumnButton = new JButton("Fields");
            chooseColumnButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ListViewTablePanel.this.columnChooser.showDialog();
                }
            });
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.fieldPanel.add((Component)chooseColumnButton, gbc);
        }
        this.setTableModel(data, columnNames, columnClasses);
        if (allowSort) {
            this.add((Component)this.fieldPanel, "North");
        }
        JScrollPane jsp = new JScrollPane((Component)this.table);
        jsp.setBorder(null);
        this.add((Component)jsp, "Center");
        this.updateData(data);
        this.updateView();
    }

    public SortableTable getTable() {
        return this.table;
    }

    public final synchronized Object[][] getData() {
        return this.data;
    }

    public final synchronized void updateData(Object[][] newData) {
        this.data = newData;
        this.model.fireTableDataChanged();
        this.table.repaint();
    }

    protected Object getKey(Object[] row) {
        return row;
    }

    private void addToRowIndexMap(Object key, Integer rowIndex) {
        Set<Integer> rowIndices = this.keyRowIndexMap.get(key);
        if (rowIndices == null) {
            rowIndices = new HashSet<Integer>();
        }
        rowIndices.add(rowIndex);
        this.keyRowIndexMap.put(key, rowIndices);
    }

    public final void updateView() {
        if (this.data == null) {
            return;
        }
        boolean first = false;
        if (this.model == null) {
            this.model = new GenericTableModel(this.data, this.columnNames, this.columnClasses);
            first = true;
        } else {
            Vector dataVec = this.model.getDataVector();
            dataVec.removeAllElements();
            int rowIndex = 0;
            this.keyRowIndexMap = new HashMap<Object, Set<Integer>>();
            for (Object[] row : this.data) {
                if (row == null) {
                    System.out.println("Got null row!");
                }
                dataVec.add(new Vector<Object>(Arrays.asList(row)));
                this.addToRowIndexMap(this.getKey(row), rowIndex++);
            }
        }
        if (first) {
            int[] columns = new int[this.columnNames.length];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = i;
            }
            this.filterField.setTableModel((TableModel)((Object)this.model));
            this.filterField.setColumnIndices(columns);
            this.filterField.setObjectConverterManagerEnabled(true);
            this.table.setModel((TableModel)new FilterableTableModel((TableModel)this.filterField.getDisplayTableModel()));
            this.columnChooser.hideColumns(this.hiddenColumns);
            int[] favColumns = new int[this.columnNames.length - this.hiddenColumns.length];
            int pos = 0;
            for (int i = 0; i < this.columnNames.length; ++i) {
                boolean hidden = false;
                for (int j = 0; j < this.hiddenColumns.length; ++j) {
                    if (this.hiddenColumns[j] != i) continue;
                    hidden = true;
                    break;
                }
                if (hidden) continue;
                favColumns[pos] = i;
                ++pos;
            }
            this.columnChooser.setFavoriteColumns(favColumns);
        } else {
            this.model.fireTableDataChanged();
        }
    }

    private void setTableModel(Object[][] data, String[] columnNames, Class[] columnClasses) {
        this.data = data;
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        this.updateView();
    }

    public void setSelectionMode(int selectionMode) {
        this.table.setSelectionMode(selectionMode);
    }

    public void forceRefreshData() {
    }

    public void setFontSize(float newSize) {
        this.fontSize = newSize;
        Font newFont = this.table.getFont().deriveFont(newSize);
        this.table.setFont(newFont);
    }

    public void scrollToIndex(int index) {
        this.table.scrollRectToVisible(this.table.getCellRect(index, 0, true));
    }

    protected int[] getSelectedRows() {
        int[] selected = this.table.getSelectedRows();
        return TableModelWrapperUtils.getActualRowsAt((TableModel)this.table.getModel(), (int[])selected, (boolean)true);
    }

    protected void addRow(Object[] rowData) {
        Object[][] r = new Object[][]{rowData};
        this.addRows(r);
    }

    protected void removeRow(int i) {
        this.removeRows(new int[]{i});
    }

    protected Object[] getRowData(int i) {
        return ((Vector)this.model.getDataVector().elementAt(i)).toArray();
    }

    protected void removeRows(int[] rows) {
        Object[][] oldData = this.getData();
        Object[][] newData = new Object[oldData.length - rows.length][];
        Arrays.sort(rows);
        int ri = 0;
        int ndi = 0;
        for (int odi = 0; odi < oldData.length; ++odi) {
            if (ri < rows.length && rows[ri] == odi) {
                ++ri;
                continue;
            }
            newData[ndi++] = oldData[odi];
        }
        this.updateData(newData);
        this.updateView();
    }

    public void removeRows(Set<Object> keySet) {
        ArrayList<Integer> rowIndices = new ArrayList<Integer>(keySet.size());
        for (Object key : keySet) {
            Set<Integer> ri = this.keyRowIndexMap.get(key);
            if (ri == null) continue;
            rowIndices.addAll(ri);
        }
        this.removeRows(ArrayUtils.toPrimitive((Integer[])rowIndices.toArray(new Integer[rowIndices.size()])));
    }

    protected void addRows(Object[][] rows) {
        Object[][] oldData = this.getData();
        Object[][] newData = new Object[rows.length + oldData.length][];
        System.arraycopy(oldData, 0, newData, 0, oldData.length);
        System.arraycopy(rows, 0, newData, oldData.length, rows.length);
        this.updateData(newData);
        this.updateView();
    }

    protected void moveItemsFromRows(ListViewTablePanel toList, int[] rows, boolean copy) {
        Object[][] oldFromData = this.getData();
        Object[][] oldToData = toList.getData();
        Object[][] newToData = new Object[oldToData.length + rows.length][];
        System.arraycopy(oldToData, 0, newToData, 0, oldToData.length);
        int i = oldToData.length;
        if (copy) {
            for (int r : rows) {
                newToData[i++] = oldFromData[r];
            }
        } else {
            for (int r : rows) {
                newToData[i++] = oldFromData[r];
                oldFromData[r] = null;
            }
        }
        toList.updateData(newToData);
        toList.updateView();
        if (!copy) {
            Object[][] newFromData = new Object[oldFromData.length - rows.length][];
            i = 0;
            for (Object[] fromRow : oldFromData) {
                if (fromRow == null) continue;
                newFromData[i++] = fromRow;
            }
            this.updateData(newFromData);
            this.updateView();
        }
    }

    public int getNumSelected() {
        return this.getSelectedRows().length;
    }

    public Set<Object> getSelectedKeys() {
        HashSet<Object> selectedKeys = new HashSet<Object>();
        for (int row : this.getSelectedRows()) {
            Object[] rowData = this.getRowData(row);
            selectedKeys.add(rowData[0]);
        }
        return selectedKeys;
    }

    public void moveSelectedItems(ListViewTablePanel toList) {
        LOG.debug((Object)("moveSelectedItems: Got keys " + this.getSelectedKeys()));
        this.moveItems(toList, this.getSelectedKeys());
    }

    public void moveItems(ListViewTablePanel toList, Set<Object> rowKeys) {
        this.copyItems(toList, rowKeys, false);
    }

    public void copyItems(ListViewTablePanel toList, Set<Object> rowKeys) {
        this.copyItems(toList, rowKeys, true);
    }

    private void copyItems(ListViewTablePanel toList, Set<Object> rowKeys, boolean copy) {
        HashSet<Integer> moveRowIndices = new HashSet<Integer>();
        HashSet<Integer> removeRowIndices = new HashSet<Integer>();
        for (Object rowKey : rowKeys) {
            Set<Integer> rowIndicesForObj = this.keyRowIndexMap.get(rowKey);
            if (rowIndicesForObj == null) continue;
            if (!toList.keyRowIndexMap.containsKey(rowKey)) {
                moveRowIndices.addAll(rowIndicesForObj);
                continue;
            }
            removeRowIndices.addAll(rowIndicesForObj);
        }
        int[] mi = ArrayUtils.toPrimitive((Integer[])moveRowIndices.toArray(new Integer[moveRowIndices.size()]));
        this.moveItemsFromRows(toList, mi, copy);
        if (!copy) {
            int[] ri = ArrayUtils.toPrimitive((Integer[])removeRowIndices.toArray(new Integer[removeRowIndices.size()]));
            this.removeRows(ri);
        }
    }

    public boolean hasKey(Object key) {
        return this.keyRowIndexMap.containsKey(key);
    }

    public boolean hasRow(Object[] row) {
        return this.keyRowIndexMap.containsKey(this.getKey(row));
    }
}

