/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class ProgressPanel
extends JPanel
implements ComponentListener {
    private static final int preferredHeight = 5;
    private int preferredWidth = 300;
    private static final int padding = 0;
    private int width_bar;
    private static final int height_bar = 20;
    private boolean animating = false;
    private int speed = 300;
    private int maxValue = 100;
    private long currentValue;
    private long lastValue;
    private double animatingValue;
    private boolean drawLastIndicator = false;
    private boolean drawShadow = true;
    Color innerColor = new Color(72, 181, 249);
    Color borderColor = new Color(150, 150, 150);
    int shadowWidth = 3;
    int rounding = 10;
    boolean legendDrawn = false;
    int arrowwidth = 8;
    int arrowheight = 10;
    int yinset = this.arrowwidth - 1;

    public ProgressPanel() {
        this.setDoubleBuffered(true);
        this.setBackground(Color.pink);
        this.setPreferredSize(new Dimension(this.preferredWidth, 5));
        this.lastValue = this.currentValue = 100L;
        this.repaint();
        this.addComponentListener(this);
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
        this.repaint();
    }

    public void animateToValue(final int val) {
        if (val > this.maxValue) {
            if (this.currentValue != (long)this.maxValue) {
                this.animateToValue(this.maxValue);
            }
            return;
        }
        if (val < 0) {
            if (this.currentValue != 0L) {
                this.animateToValue(0);
            }
            return;
        }
        final ProgressPanel ap = this;
        Thread t = new Thread(){

            @Override
            public void run() {
                if (ap == null || ap.getWidth() == 0) {
                    return;
                }
                ap.animating = true;
                ap.animatingValue = ap.currentValue;
                boolean forward = (long)val > ProgressPanel.this.currentValue;
                int it = 0;
                while (true) {
                    ++it;
                    if (forward) {
                        ap.animatingValue = ap.animatingValue + (double)(ProgressPanel.this.maxValue / ap.getWidth());
                    } else {
                        ap.animatingValue = ap.animatingValue - (double)(ProgressPanel.this.maxValue / ap.getWidth());
                    }
                    if (forward && ap.animatingValue >= (double)val || !forward && ap.animatingValue <= (double)val) break;
                    ap.repaint();
                    try {
                        Thread.sleep(1000 / ProgressPanel.this.speed);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ap.animating = false;
                ap.lastValue = ap.currentValue;
                ap.currentValue = val;
                ap.repaint();
            }
        };
        t.run();
    }

    public void draw(Graphics g) {
        this.drawPanel(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.draw(g);
    }

    private long getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        this.preferredWidth = this.getWidth();
        this.setPreferredSize(new Dimension(this.preferredWidth, 5));
        this.draw(this.getGraphics());
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    @Override
    public void componentShown(ComponentEvent ce) {
        this.draw(this.getGraphics());
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
    }

    private void drawPanel(Graphics g) {
        this.width_bar = this.preferredWidth - 0;
        Rectangle2D.Double fullRect = new Rectangle2D.Double(0.0, 0.0, this.width_bar, 20.0);
        Graphics2D g2 = (Graphics2D)g;
        if (g2 == null) {
            return;
        }
        int startx = 0;
        int starty = 0;
        double width = 0.0;
        double height = 20.0;
        try {
            width = this.animating ? this.animatingValue * (double)this.width_bar / (double)this.maxValue : (double)(this.currentValue * (long)this.width_bar / (long)this.maxValue);
        }
        catch (ArithmeticException ex) {
            width = 0.0;
        }
        Rectangle2D.Double r2 = new Rectangle2D.Double(startx, starty, width, height);
        g2.setColor(Color.white);
        g2.fill(fullRect);
        g2.setColor(this.innerColor);
        g2.fill(r2);
        g2.setColor(this.borderColor);
        g2.draw(r2);
        Stroke s = g2.getStroke();
        if (this.drawLastIndicator) {
            double lastwidth = (long)startx + this.lastValue * (long)this.width_bar / (long)this.maxValue;
            Rectangle2D.Double line = new Rectangle2D.Double(lastwidth, starty, 0.1, height);
            g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f));
            g2.setColor(Color.darkGray);
            g2.draw(line);
        }
        g2.setStroke(s);
        g2.setColor(Color.gray);
        g2.draw(fullRect);
        if (this.drawShadow) {
            int sw;
            for (int i = sw = this.shadowWidth; i >= 0; --i) {
                g2.setColor(new Color(10, 10, 10, 110 - i * 110 / sw));
                g2.drawLine(startx, starty + i, this.width_bar + 0, starty + i);
            }
        }
        g2.dispose();
    }

    private void clearForIndicator(int width, int startx, int starty) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.clearRect(startx - this.arrowwidth / 2, starty - this.arrowheight + this.yinset, width + this.arrowwidth, this.arrowheight - this.yinset);
    }

    private void drawIndicator(double x, double y, Color c) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(c);
        Path2D.Double p = new Path2D.Double();
        p.moveTo(x, (double)this.yinset + y);
        p.lineTo(x, (double)this.yinset + y - (double)this.arrowheight);
        p.lineTo(x + (double)(this.arrowwidth / 2), (double)this.yinset + y - (double)this.arrowheight);
        p.closePath();
        g.fill(p);
        p = new Path2D.Double();
        p.moveTo(x, (double)this.yinset + y);
        p.lineTo(x, (double)this.yinset + y - (double)this.arrowheight);
        p.lineTo(x - (double)(this.arrowwidth / 2), (double)this.yinset + y - (double)this.arrowheight);
        p.closePath();
        g.fill(p);
    }

    public void setToValue(int val) {
        this.currentValue = val;
        this.repaint();
    }
}

