/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.images.ImagePanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class AppSwitchPanel
extends JPanel {
    private boolean isSwitching;
    private int selectedIndex;
    private List<LaunchableApp> apps;
    int maxApps = 5;

    public AppSwitchPanel() {
        this((JComponent)null);
    }

    public AppSwitchPanel(JComponent componentToListenOn) {
        this.setOpaque(false);
        KeyStroke escapeListeningKeystroke = KeyStroke.getKeyStroke(27, 4, true);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppSwitchPanel.this.isSwitching) {
                    AppSwitchPanel.this.selectedIndex = -1;
                    AppSwitchPanel.this.setSwitching(false);
                }
            }
        };
        KeyStroke dashBoardListeningKeystroke = KeyStroke.getKeyStroke(38, 4, true);
        AbstractAction dashBoardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedSavantFrame.getInstance().getDashboard().goHome();
                if (AppSwitchPanel.this.isSwitching) {
                    AppSwitchPanel.this.selectedIndex = -1;
                    AppSwitchPanel.this.setSwitching(false);
                }
            }
        };
        KeyStroke appSwitchStopListeningKeystroke = KeyStroke.getKeyStroke(157, 0, true);
        AbstractAction appSwitchStopAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppSwitchPanel.this.setSwitching(false);
            }
        };
        KeyStroke appRightSwitchKeystroke = KeyStroke.getKeyStroke(39, 4, true);
        AbstractAction appRightSwitchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppSwitchPanel.this.setSwitching(true);
                AppSwitchPanel.this.shiftRight();
            }
        };
        KeyStroke appLeftSwitchKeystroke = KeyStroke.getKeyStroke(37, 4, true);
        AbstractAction appLeftSwitchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppSwitchPanel.this.setSwitching(true);
                AppSwitchPanel.this.shiftLeft();
            }
        };
        if (componentToListenOn == null) {
            componentToListenOn = this;
        }
        componentToListenOn.getInputMap(2).put(appSwitchStopListeningKeystroke, "SwitchAppStop");
        componentToListenOn.getActionMap().put("SwitchAppStop", appSwitchStopAction);
        componentToListenOn.getInputMap(2).put(appLeftSwitchKeystroke, "SwitchAppLeft");
        componentToListenOn.getActionMap().put("SwitchAppLeft", appLeftSwitchAction);
        componentToListenOn.getInputMap(2).put(appRightSwitchKeystroke, "SwitchAppRight");
        componentToListenOn.getActionMap().put("SwitchAppRight", appRightSwitchAction);
        componentToListenOn.getInputMap(2).put(dashBoardListeningKeystroke, "Dash");
        componentToListenOn.getActionMap().put("Dash", dashBoardAction);
        componentToListenOn.getInputMap(2).put(escapeListeningKeystroke, "Escape");
        componentToListenOn.getActionMap().put("Escape", escapeAction);
    }

    private void shiftLeft() {
        if (!this.isSwitching) {
            return;
        }
        this.selectedIndex = this.selectedIndex == 0 ? this.apps.size() - 1 : --this.selectedIndex;
        this.refresh();
    }

    private void shiftRight() {
        if (!this.isSwitching) {
            return;
        }
        this.selectedIndex = this.selectedIndex == this.apps.size() - 1 ? 0 : ++this.selectedIndex;
        this.refresh();
    }

    private void setSwitching(boolean isSwitching) {
        if (this.isSwitching != isSwitching) {
            if (isSwitching) {
                List<LaunchableApp> history = MedSavantFrame.getInstance().getDashboard().getLaunchHistory();
                System.out.println(history);
                if (history.isEmpty()) {
                    return;
                }
                this.selectedIndex = 0;
                this.apps = history.subList(0, Math.min(history.size(), this.maxApps));
            } else if (this.selectedIndex != -1) {
                MedSavantFrame.getInstance().getDashboard().launchApp(this.apps.get(this.selectedIndex));
            }
            this.isSwitching = isSwitching;
            this.refresh();
        }
    }

    private void refresh() {
        this.removeAll();
        if (this.isSwitching) {
            int shadowSize = 10;
            JPanel p = ViewUtil.getRoundedShadowedPanel(Color.white, new Color(245, 245, 245), 0.9f, 10, new Color(230, 230, 230), shadowSize);
            p.setLayout((LayoutManager)new MigLayout("insets 30"));
            int appNum = 0;
            for (LaunchableApp app : this.apps) {
                p.add((Component)new ImagePanel(ViewUtil.getScaledInstance(app.getIcon().getImage(), 128, 128, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true)), String.format("cell %d 0", appNum));
                JLabel l = new JLabel(app.getName());
                if (appNum == this.selectedIndex) {
                    l.setFont(l.getFont().deriveFont(1));
                }
                p.add((Component)l, String.format("cell %d 1, center", appNum));
                ++appNum;
            }
            this.setLayout((LayoutManager)new MigLayout("fillx, filly, center"));
            this.add((Component)p, "center, growx 1.0");
            p.repaint();
        }
        this.updateUI();
    }
}

