/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.layout.GroupLayout;
import org.ut.biolab.medsavant.client.view.dialog.BugReport;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.util.VersionSettings;

public class BugReportDialog
extends JDialog {
    private Throwable exception;
    private String toolName = "MedSavant";
    private String toolVersion = VersionSettings.getVersionString();
    private JTextArea areaProblem;
    private JTextField fieldEmail;
    private JTextField fieldInstitute;
    private JTextField fieldName;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;

    public BugReportDialog(Frame parent) {
        this(parent, null, null);
    }

    public BugReportDialog(Frame parent, String description) {
        this(parent, description, null);
    }

    public BugReportDialog(Frame parent, Throwable e) {
        this(parent, null, e);
    }

    public BugReportDialog(Frame parent, String description, Throwable e) {
        super(parent, true);
        this.initComponents();
        if (description != null) {
            this.areaProblem.setText(description);
        }
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.exception = e;
    }

    private void initComponents() {
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.fieldName = new JTextField();
        this.fieldInstitute = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.areaProblem = new JTextArea();
        this.jButton1 = new JButton();
        this.jLabel4 = new JLabel();
        this.fieldEmail = new JTextField();
        this.jTextField1.setText("jTextField1");
        this.setDefaultCloseOperation(2);
        this.setTitle("Report Issue");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Name");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Email");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Organization");
        this.areaProblem.setColumns(20);
        this.areaProblem.setRows(5);
        this.jScrollPane1.setViewportView(this.areaProblem);
        this.jButton1.setText("Submit");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BugReportDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("<html>Description of Issue</html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButton1)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel3).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.fieldName).add((Component)this.fieldEmail).add(2, (Component)this.fieldInstitute).add(2, (Component)this.jScrollPane1, -1, 418, Short.MAX_VALUE).add(2, (Component)this.jLabel4)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.fieldName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fieldEmail, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fieldInstitute, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jLabel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 279, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String name = this.fieldName.getText();
        String email = this.fieldEmail.getText();
        String institute = this.fieldInstitute.getText();
        String description = this.areaProblem.getText();
        if (name.isEmpty() || email.isEmpty() || institute.isEmpty() || description.isEmpty()) {
            if (name.isEmpty()) {
                DialogUtils.displayMessage("Please fill in your name");
                this.fieldName.requestFocus();
                return;
            }
            if (email.isEmpty()) {
                DialogUtils.displayMessage("Please fill in your email address");
                this.fieldEmail.requestFocus();
                return;
            }
            if (institute.isEmpty()) {
                DialogUtils.displayMessage("Please fill in your organization");
                this.fieldInstitute.requestFocus();
                return;
            }
            if (description.isEmpty()) {
                DialogUtils.displayMessage("Please fill in a description of the issue");
                this.areaProblem.requestFocus();
            }
        } else {
            this.setVisible(false);
            try {
                BugReport.reportBug(this.toolName, this.toolVersion, name, email, institute, description, this.exception);
                DialogUtils.displayMessage("Thank you for reporting your issue.");
            }
            catch (UnsupportedEncodingException ex) {
                DialogUtils.displayMessage("Error reporting issue.");
            }
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BugReportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BugReportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BugReportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BugReportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BugReportDialog dialog = new BugReportDialog((Frame)new JFrame(), new Exception("Fake exception"));
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

