/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.shared.model.ProgressStatus;

public abstract class CancellableProgressDialog
extends ProgressDialog {
    protected boolean cancelled = false;
    private JLabel stageLabel;
    private JButton cancelButton;
    protected ProgressStatus lastStatus = new ProgressStatus("Preparing...", 0.0);
    private boolean waitForCancelConfirmation;

    public CancellableProgressDialog(String title, String message) {
        this(title, message, true);
    }

    public CancellableProgressDialog(String title, String message, boolean waitForConfirmationOnCancel) {
        super(title, message, true);
        this.stageLabel = new JLabel("Preparing...");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CancellableProgressDialog.this.cancelled = true;
                try {
                    CancellableProgressDialog.this.progressTimer.stop();
                    CancellableProgressDialog.this.stageLabel.setText("Cancelling...");
                    CancellableProgressDialog.this.cancelButton.setEnabled(false);
                    ProgressDialog.LOG.info((Object)"Calling checkProgress to tell server that we've cancelled.");
                    CancellableProgressDialog.this.checkProgress();
                    if (!CancellableProgressDialog.this.waitForCancelConfirmation) {
                        CancellableProgressDialog.this.setVisible(false);
                    }
                }
                catch (Exception ex) {
                    ProgressDialog.LOG.info((Object)"Ignoring exception thrown while checking for progress.", (Throwable)ex);
                }
            }
        });
        Container p = this.getContentPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 45, 3, 45);
        p.add((Component)this.stageLabel, gbc);
        gbc.fill = 0;
        gbc.insets = new Insets(3, 45, 15, 45);
        p.add((Component)this.cancelButton, gbc);
        this.progressTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    ProgressStatus status = CancellableProgressDialog.this.checkProgress();
                    if (status != null) {
                        if (status.fractionCompleted == -1.0) {
                            CancellableProgressDialog.this.bar.setIndeterminate(true);
                        } else {
                            CancellableProgressDialog.this.bar.setValue((int)Math.round(status.fractionCompleted * 100.0));
                            CancellableProgressDialog.this.bar.setIndeterminate(false);
                        }
                        CancellableProgressDialog.this.stageLabel.setText(status.message);
                    }
                }
                catch (Exception ex) {
                    ProgressDialog.LOG.info((Object)"Ignoring exception thrown while checking for progress.", (Throwable)ex);
                }
            }
        });
        this.setWaitForCancelConfirmation(waitForConfirmationOnCancel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public final void setWaitForCancelConfirmation(boolean b) {
        this.waitForCancelConfirmation = b;
    }

    public ProgressStatus checkProgress() throws Exception {
        return this.lastStatus;
    }
}

