/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SpringLayout;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.SpringUtilities;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class ChangePasswordDialog
extends JDialog {
    private static final int INIT_X = 6;
    private static final int INIT_Y = 6;
    private static final int XPAD = 6;
    private static final int YPAD = 6;
    private static final int PASSWORD_FIELD_NUMCHARS = 25;
    private static final int PASSWORD_MIN_LENGTH = 6;
    private static final int PASSWORD_MAX_LENGTH = 0;
    private static Pattern REGEXP_PASSWORD = Pattern.compile("\\S+");
    private static final String[] LABELS = new String[]{"Enter Current Password", "Enter New Password", "Confirm New Password"};

    public ChangePasswordDialog() {
        super(MedSavantFrame.getInstance());
        final JPasswordField[] textFields = new JPasswordField[LABELS.length];
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel p = new JPanel(new SpringLayout());
        for (int i = 0; i < LABELS.length; ++i) {
            JLabel l = new JLabel(LABELS[i]);
            p.add(l);
            textFields[i] = new JPasswordField(25);
            l.setLabelFor(textFields[i]);
            p.add(textFields[i]);
        }
        SpringUtilities.makeCompactGrid(p, LABELS.length, 2, 6, 6, 6, 6);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton OKButton = new JButton("OK");
        OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ChangePasswordDialog.this.dispose();
                ChangePasswordDialog.this.submit(textFields);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ChangePasswordDialog.this.dispose();
            }
        });
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(OKButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        mainPanel.add(p);
        mainPanel.add(buttonPanel);
        this.setContentPane(mainPanel);
        this.pack();
        this.setLocationRelativeTo(MedSavantFrame.getInstance());
    }

    protected void submit(JPasswordField[] textfields) {
        String newPass1 = String.copyValueOf(textfields[1].getPassword());
        String newPass2 = String.copyValueOf(textfields[2].getPassword());
        if (newPass1 != null && newPass2 != null) {
            if (!newPass1.equals(newPass2)) {
                DialogUtils.displayError("Invalid Password!", "The entered passwords do not match!");
                return;
            }
            if (newPass1.length() < 6) {
                String msg = "New Password is too short -- must be ";
                msg = msg + " at least 6 characters";
                DialogUtils.displayError("Invalid Password!", msg);
                return;
            }
            if (!REGEXP_PASSWORD.matcher(newPass1).matches()) {
                DialogUtils.displayError("Invalid Password!", "New password contains illegal characters -- password must not contain spaces");
                return;
            }
            try {
                MedSavantClient.UserManager.changePassword(LoginController.getSessionID(), LoginController.getInstance().getUserName(), textfields[0].getPassword(), textfields[1].getPassword());
                DialogUtils.displayMessage("Password successfully changed.");
            }
            catch (RemoteException re) {
                DialogUtils.displayException("Error changing password", re.getMessage(), re);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("08001")) {
                    DialogUtils.displayError("Access Denied", "The current password is invalid, password NOT changed");
                } else {
                    DialogUtils.displayException("Error changing password", "Error changing password", se);
                }
            }
            catch (SessionExpiredException see) {
                MedSavantExceptionHandler.handleSessionExpiredException(see);
            }
        }
    }
}

