/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;
import org.ut.biolab.medsavant.client.util.DownloadEvent;
import org.ut.biolab.medsavant.client.util.DownloadMonitor;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;

public class DownloadDialog
extends JDialog
implements DownloadMonitor {
    private boolean complete;
    private boolean cancelled;
    private String shortName;
    private File downloadedFile;
    private JButton cancelButton;
    private JLabel destinationLabel;
    private JLabel fileLabel;
    private JProgressBar progressBar;
    private JLabel stageLabel;

    public DownloadDialog(Window parent, boolean modal) {
        super(parent, modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownloadDialog.this.askToDispose();
            }
        });
    }

    private void initComponents() {
        JLabel fileCaption = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.fileLabel = new JLabel();
        JLabel destinationCaption = new JLabel();
        this.destinationLabel = new JLabel();
        this.stageLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        fileCaption.setFont(fileCaption.getFont().deriveFont(fileCaption.getFont().getStyle() | 1));
        fileCaption.setText("Downloading: ");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.fileLabel.setText("filename");
        destinationCaption.setFont(destinationCaption.getFont().deriveFont(destinationCaption.getFont().getStyle() | 1));
        destinationCaption.setText("To:");
        this.destinationLabel.setText("destination");
        this.stageLabel.setText("Starting download...");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -1, 441, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(fileCaption).addComponent(destinationCaption)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileLabel, -2, 329, -2).addComponent(this.destinationLabel, -2, 329, -2))).addComponent(this.cancelButton, GroupLayout.Alignment.TRAILING).addComponent(this.stageLabel, -2, 407, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fileCaption).addComponent(this.fileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(destinationCaption).addComponent(this.destinationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.stageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, -1, -2).addGap(11, 11, 11).addComponent(this.cancelButton).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.askToDispose();
    }

    private void askToDispose() {
        if (!this.complete) {
            int result = DialogUtils.askYesNo("Cancel Download", "Are you sure you want to cancel?");
            if (result == 0) {
                try {
                    this.downloadedFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.downloadedFile = null;
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    public void downloadFile(URL url, File destDir, String fileName) {
        this.shortName = fileName != null ? fileName : ClientMiscUtils.getFilenameFromPath(url.getPath());
        this.setTitle("Downloading " + this.shortName);
        this.fileLabel.setText(url.toString());
        this.destinationLabel.setText(destDir.getPath());
        this.downloadedFile = new File(destDir, this.shortName);
        ClientNetworkUtils.downloadFile(url, destDir, this.shortName, this);
        this.setVisible(true);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    @Override
    public void handleEvent(DownloadEvent event) {
        switch (event.getType()) {
            case STARTED: {
                break;
            }
            case PROGRESS: {
                int progress = (int)(event.getProgress() * 100.0);
                this.stageLabel.setText(String.format("Downloaded %d%%", progress));
                this.progressBar.setValue(progress);
                break;
            }
            case COMPLETED: {
                this.dispose();
                ((Window)this.getParent()).toFront();
                if (!this.cancelled) break;
                this.downloadedFile = null;
                break;
            }
            case FAILED: {
                this.downloadedFile = null;
                DialogUtils.displayException("Download Error", String.format("<html>Download of <i>%s</i> failed.", this.shortName), event.getError());
            }
        }
    }
}

