/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.CacheController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.DataRetriever;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.SearchableTablePanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.SimplePatient;
import org.ut.biolab.medsavant.shared.util.ModificationType;

public class IndividualSelector
extends JDialog
implements BasicPatientColumns {
    Set<String> selectedHospitalIDs;
    private static final Log LOG = LogFactory.getLog(IndividualSelector.class);
    private JPanel middlePanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private boolean forceRefresh = false;
    private static final String[] COLUMN_NAMES = new String[]{PATIENT_ID.getAlias(), FAMILY_ID.getAlias(), HOSPITAL_ID.getAlias(), IDBIOMOM.getAlias(), IDBIODAD.getAlias(), GENDER.getAlias(), AFFECTED.getAlias(), DNA_IDS.getAlias(), PHENOTYPES.getAlias(), "Cohort(s)"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static final int[] HIDDEN_COLUMNS = new int[]{0, 3, 4, 7};
    private SearchableTablePanel individualsSTP;
    private JLabel numselections;
    private IndividualsReceiver individualsRetriever;
    private HashSet<Integer> selectedRows;
    private JButton ok;
    private boolean hasMadeSelections;
    private boolean onlyOnePatient;

    public IndividualSelector(boolean onlyOnePatient) {
        super((Frame)MedSavantFrame.getInstance(), true);
        this.onlyOnePatient = onlyOnePatient;
        this.setTitle(onlyOnePatient ? "Select Individual" : "Select Individual(s)");
        this.setPreferredSize(new Dimension(700, 600));
        this.setMinimumSize(new Dimension(700, 600));
        this.selectedHospitalIDs = new HashSet<String>();
        this.selectedRows = new HashSet();
        this.initUI();
        this.refresh();
    }

    public IndividualSelector() {
        this(false);
    }

    public Set<String> getHospitalIDsOfSelectedIndividuals() {
        return this.selectedHospitalIDs;
    }

    public Set<String> getDNAIDsOfSelectedIndividuals() {
        HashSet<String> ids = new HashSet<String>();
        for (int i : this.selectedRows) {
            String dnaID = (String)this.individualsRetriever.getIndividuals().get(i)[7];
            ids.add(dnaID);
        }
        return ids;
    }

    public void refresh() {
        this.individualsSTP.forceRefreshData();
    }

    private void initUI() {
        JPanel p = new JPanel();
        ViewUtil.applyVerticalBoxLayout(p);
        this.add(p);
        this.topPanel = ViewUtil.getClearPanel();
        this.middlePanel = ViewUtil.getClearPanel();
        this.bottomPanel = ViewUtil.getClearPanel();
        p.add(this.topPanel);
        p.add(this.middlePanel);
        p.add(this.bottomPanel);
        if (this.onlyOnePatient) {
            this.bottomPanel.setVisible(false);
        }
        this.middlePanel.setLayout(new BorderLayout());
        this.individualsRetriever = new IndividualsReceiver();
        this.individualsSTP = new SearchableTablePanel("Individuals", COLUMN_NAMES, COLUMN_CLASSES, HIDDEN_COLUMNS, true, true, Integer.MAX_VALUE, false, SearchableTablePanel.TableSelectionType.ROW, Integer.MAX_VALUE, this.individualsRetriever);
        this.individualsSTP.setExportButtonVisible(false);
        CacheController.getInstance().addListener(new Listener<ModificationType>(){

            @Override
            public void handleEvent(ModificationType event) {
                if (!(event != ModificationType.PATIENT && event != ModificationType.COHORT || IndividualSelector.this.individualsSTP.isUpdating())) {
                    IndividualSelector.this.forceRefresh = true;
                    IndividualSelector.this.individualsSTP.forceRefreshData();
                }
            }
        });
        this.middlePanel.add((Component)this.individualsSTP, "Center");
        ViewUtil.applyVerticalBoxLayout(this.bottomPanel);
        this.numselections = ViewUtil.getTitleLabel("0 individual(s) selected");
        JPanel text = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(text);
        JButton clearIndividuals = ViewUtil.getIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CLOSE));
        clearIndividuals.setToolTipText("Clear selections");
        clearIndividuals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IndividualSelector.this.clearSelections();
            }
        });
        text.add(this.numselections);
        text.add(Box.createHorizontalStrut(5));
        text.add(clearIndividuals);
        this.bottomPanel.add(ViewUtil.centerHorizontally(text));
        JButton addAllIndividuals = ViewUtil.getSoftButton("Add All");
        this.bottomPanel.add(addAllIndividuals);
        final JButton addIndividuals = ViewUtil.getSoftButton("Add Selected");
        this.bottomPanel.add(addIndividuals);
        final JButton removeIndividuals = ViewUtil.getSoftButton("Remove Selected");
        this.bottomPanel.add(removeIndividuals);
        JButton removeAllIndividuals = ViewUtil.getSoftButton("Remove All");
        this.bottomPanel.add(removeAllIndividuals);
        JPanel buttons = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(buttons);
        buttons.add(addAllIndividuals);
        buttons.add(addIndividuals);
        buttons.add(removeIndividuals);
        buttons.add(removeAllIndividuals);
        JPanel windowControlPanel = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(windowControlPanel);
        windowControlPanel.add(Box.createHorizontalGlue());
        JButton cancel = new JButton("Cancel");
        this.bottomPanel.add(ViewUtil.centerHorizontally(buttons));
        this.ok = new JButton("OK");
        this.bottomPanel.add(ViewUtil.alignRight(this.ok));
        this.ok.setEnabled(false);
        windowControlPanel.add(cancel);
        windowControlPanel.add(this.ok);
        this.bottomPanel.add(windowControlPanel);
        final IndividualSelector instance = this;
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                instance.setVisible(false);
                IndividualSelector.this.setIndividualsChosen(true);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                instance.setVisible(false);
                IndividualSelector.this.setIndividualsChosen(IndividualSelector.this.hasMadeSelections);
            }
        });
        addIndividuals.setEnabled(false);
        removeIndividuals.setEnabled(false);
        this.individualsSTP.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    int[] rows = IndividualSelector.this.individualsSTP.getTable().getSelectedRows();
                    boolean someSelection = rows.length > 0;
                    addIndividuals.setEnabled(someSelection);
                    removeIndividuals.setEnabled(someSelection);
                    if (someSelection) {
                        addIndividuals.setText("Add Selected (" + rows.length + ")");
                        removeIndividuals.setText("Remove Selected (" + rows.length + ")");
                    } else {
                        addIndividuals.setText("Add Selected");
                        removeIndividuals.setText("Remove Selected");
                    }
                    if (IndividualSelector.this.onlyOnePatient && rows.length == 1) {
                        IndividualSelector.this.selectedRows.clear();
                        IndividualSelector.this.selectedHospitalIDs.clear();
                        int realRow = IndividualSelector.this.individualsSTP.getActualRowAt(rows[0]);
                        IndividualSelector.this.selectedRows.add(realRow);
                        Object[] o = IndividualSelector.this.individualsRetriever.getIndividuals().get(realRow);
                        IndividualSelector.this.selectedHospitalIDs.add(o[2].toString());
                        instance.setVisible(false);
                        IndividualSelector.this.setIndividualsChosen(true);
                        IndividualSelector.this.individualsSTP.getTable().clearSelection();
                    }
                }
            }
        });
        this.individualsSTP.getTable().getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
            }
        });
        ActionListener addAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IndividualSelector.this.addSelections(false);
            }
        };
        ActionListener addAllAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IndividualSelector.this.addSelections(true);
            }
        };
        ActionListener removeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IndividualSelector.this.removeSelections(false);
            }
        };
        ActionListener removeAllAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IndividualSelector.this.removeSelections(true);
            }
        };
        addIndividuals.addActionListener(addAction);
        addAllIndividuals.addActionListener(addAllAction);
        removeIndividuals.addActionListener(removeAction);
        removeAllIndividuals.addActionListener(removeAllAction);
        this.pack();
        this.setLocationRelativeTo(MedSavantFrame.getInstance());
    }

    private void setIndividualsChosen(boolean b) {
        this.hasMadeSelections = b;
    }

    private void refreshSelectionIndicator() {
        String tooltipText = "<html>";
        for (String o : this.selectedHospitalIDs) {
            tooltipText = tooltipText + o + "<br>";
        }
        tooltipText = tooltipText + "</html>";
        this.numselections.setToolTipText(tooltipText);
        this.individualsSTP.setToggledRows(this.selectedRows);
        this.numselections.setText(this.selectedHospitalIDs.size() + " individual(s) selected");
        this.ok.setEnabled(this.selectedHospitalIDs.size() > 0);
    }

    private void clearSelections() {
        this.selectedHospitalIDs.removeAll(this.selectedHospitalIDs);
        this.selectedRows.removeAll(this.selectedRows);
        this.individualsSTP.setToggledRows(null);
        this.refreshSelectionIndicator();
    }

    private void removeSelections(boolean all) {
        int[] rows;
        ArrayList<Object[]> toUnselect = new ArrayList<Object[]>();
        if (all) {
            int rowCount = this.individualsSTP.getTable().getModel().getRowCount();
            rows = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                rows[i] = i;
            }
        } else {
            rows = this.individualsSTP.getTable().getSelectedRows();
        }
        for (int r : rows) {
            int realRow = this.individualsSTP.getActualRowAt(r);
            Object[] o = this.individualsRetriever.getIndividuals().get(realRow);
            toUnselect.add(o);
        }
        for (int i : rows) {
            this.selectedRows.remove(this.individualsSTP.getActualRowAt(i));
        }
        for (Object[] s : toUnselect) {
            this.selectedHospitalIDs.remove(s[2].toString());
        }
        this.refreshSelectionIndicator();
    }

    private void addSelections(boolean all) {
        int[] rows;
        ArrayList<Object[]> selected = new ArrayList<Object[]>();
        if (all) {
            int rowCount = this.individualsSTP.getTable().getModel().getRowCount();
            rows = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                rows[i] = i;
            }
        } else {
            rows = this.individualsSTP.getTable().getSelectedRows();
        }
        for (int r : rows) {
            int realRow = this.individualsSTP.getActualRowAt(r);
            Object[] o = this.individualsRetriever.getIndividuals().get(realRow);
            selected.add(o);
        }
        for (int i : rows) {
            this.selectedRows.add(this.individualsSTP.getActualRowAt(i));
        }
        for (Object[] s : selected) {
            this.selectedHospitalIDs.add(s[2].toString());
        }
        this.refreshSelectionIndicator();
    }

    public void setSelectedIndividuals(Set<String> s) {
        this.selectedRows.removeAll(this.selectedRows);
        this.selectedHospitalIDs = s;
        this.hasMadeSelections = true;
        for (String arbitraryHostpitalID : s) {
            int rowNumber = 0;
            List<Object[]> individuals = this.individualsRetriever.getIndividuals();
            for (Object[] inOrderRow : individuals) {
                if (inOrderRow[2].equals(arbitraryHostpitalID)) {
                    this.selectedRows.add(rowNumber);
                }
                ++rowNumber;
            }
        }
        this.refreshSelectionIndicator();
    }

    public boolean hasMadeSelection() {
        return this.hasMadeSelections;
    }

    public void resetSelections() {
        this.setSelectedIndividuals(new HashSet<String>());
        this.hasMadeSelections = false;
    }

    public Set<String> getInverseOfHospitalIDsOfSelectedIndividuals() {
        List<Object[]> allRows = this.individualsRetriever.getIndividuals();
        HashSet<String> results = new HashSet<String>();
        Set<String> selected = this.getHospitalIDsOfSelectedIndividuals();
        for (Object[] row : allRows) {
            String id = (String)row[2];
            if (selected.contains(id)) continue;
            results.add(id);
        }
        return results;
    }

    public class IndividualsReceiver
    extends DataRetriever<Object[]> {
        private List<Object[]> individuals;
        private HashMap<String, List<String>> hospitalIDToCohortMap;

        public List<Object[]> getIndividuals() {
            return this.individuals;
        }

        @Override
        public List<Object[]> retrieve(int start, int limit) throws Exception {
            if (this.individuals == null || IndividualSelector.this.forceRefresh) {
                this.setIndividuals();
                IndividualSelector.this.forceRefresh = false;
            }
            return this.individuals;
        }

        @Override
        public int getTotalNum() {
            if (this.individuals == null) {
                try {
                    this.setIndividuals();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    ex.printStackTrace();
                }
            }
            return this.individuals.size();
        }

        @Override
        public void retrievalComplete() {
        }

        private void setIndividuals() throws SQLException, RemoteException {
            try {
                this.setCohorts();
                List<Object[]> tmpIndividuals = MedSavantClient.PatientManager.getBasicPatientInfo(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), Integer.MAX_VALUE);
                ArrayList<Object[]> updatedIndividuals = new ArrayList<Object[]>();
                for (Object[] row : tmpIndividuals) {
                    Integer i;
                    Boolean b;
                    row[5] = ClientMiscUtils.genderToString((Integer)row[5]);
                    Object o = row[6];
                    String s = o instanceof Boolean ? ((b = (Boolean)o) != false ? "Yes" : "No") : (o instanceof Integer ? ((i = (Integer)o) > 0 ? "Yes" : "No") : "Unknown");
                    row[6] = s;
                    List<String> cohorts = this.hospitalIDToCohortMap.get((String)row[2]);
                    String cohortString = "";
                    if (cohorts != null) {
                        cohortString = StringUtils.join((Object[])cohorts.toArray(), (String)", ");
                    }
                    row = ArrayUtils.addAll((Object[])row, (Object[])new String[]{cohortString});
                    updatedIndividuals.add(row);
                }
                this.individuals = updatedIndividuals;
            }
            catch (SessionExpiredException e) {
                MedSavantExceptionHandler.handleSessionExpiredException(e);
            }
        }

        private void setCohorts() throws SQLException, SessionExpiredException, RemoteException {
            Cohort[] cohorts;
            this.hospitalIDToCohortMap = new HashMap();
            for (Cohort c : cohorts = MedSavantClient.CohortManager.getCohorts(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID())) {
                c.getId();
                List<SimplePatient> patients = MedSavantClient.CohortManager.getIndividualsInCohort(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), c.getId());
                for (SimplePatient p : patients) {
                    List<String> cohortsForPatient = this.hospitalIDToCohortMap.containsKey(p.getHospitalId()) ? this.hospitalIDToCohortMap.get(p.getHospitalId()) : new ArrayList<String>();
                    cohortsForPatient.add(c.getName());
                    this.hospitalIDToCohortMap.put(p.getHospitalId(), cohortsForPatient);
                }
            }
        }
    }
}

