/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.genetics.RangeAnnotation;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticVariantInspector;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class ChromosomeDiagramPanel
extends JPanel
implements Listener<VariantRecord> {
    private long scaleWRTLength;
    private final Chromosome chr;
    private List<RangeAnnotation> annotations;
    private static final int AMAXBINSIZE = 60000000;
    private VariantRecord selectedVariant;
    private static final Color[] HEATMAP_COLORS = new Color[]{new Color(126, 243, 125), new Color(248, 128, 128)};

    public ChromosomeDiagramPanel(Chromosome c) {
        this.chr = c;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(20, 999));
        this.setMaximumSize(new Dimension(20, 999));
        this.annotations = new ArrayList<RangeAnnotation>();
        StaticVariantInspector.addVariantSelectionChangedListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        long cent = this.chr.getCentromerePos();
        if (cent == -1L) {
            cent = this.chr.getLength() / 2;
        }
        int centView = ChromosomeDiagramPanel.translateModelToView(cent, this.chr.getLength(), this.getEffectiveHeight());
        int bend = 20;
        int width = this.getWidth() - 1;
        g2.setColor(Color.white);
        g2.fillRoundRect(0, 0, width, centView, bend, bend);
        g2.setColor(Color.gray);
        RoundRectangle2D.Double rec1 = new RoundRectangle2D.Double(0.0, 0.0, width, centView, bend, bend);
        g2.draw(rec1);
        g2.setColor(Color.white);
        g2.fillRoundRect(0, centView, width, this.getEffectiveHeight() - centView, bend, bend);
        g2.setColor(Color.gray);
        RoundRectangle2D.Double rec2 = new RoundRectangle2D.Double(0.0, centView, width, this.getEffectiveHeight() - centView, bend, bend);
        g2.draw(rec2);
        Area shape = new Area(rec1);
        shape.add(new Area(rec2));
        g2.clip(shape);
        for (RangeAnnotation a : this.annotations) {
            int viewStart = ChromosomeDiagramPanel.translateModelToView(a.getStart(), this.chr.getLength(), this.getEffectiveHeight());
            int viewEnd = ChromosomeDiagramPanel.translateModelToView(a.getEnd(), this.chr.getLength(), this.getEffectiveHeight());
            if (viewEnd - viewStart < 1) {
                viewEnd = viewStart + 1;
            }
            g2.setColor(a.getColor());
            g2.fillRect(0, viewStart, width, viewEnd - viewStart);
        }
        if (this.selectedVariant != null && this.selectedVariant.getChrom().equals(this.chr.getName())) {
            g2.setColor(new Color(0, 148, 54));
            int pos = ChromosomeDiagramPanel.translateModelToView(this.selectedVariant.getStartPosition(), this.chr.getLength(), this.getEffectiveHeight());
            g2.fillRect(1, pos, width - 1, 3);
        }
    }

    protected void setScaleWithRespectToLength(long len) {
        this.scaleWRTLength = len;
        this.repaint();
    }

    private int getEffectiveHeight() {
        return (int)((long)this.getHeight() * (long)this.chr.getLength() / this.scaleWRTLength) - 1;
    }

    private static int translateModelToView(long modelPosition, long totalViewSize, int totalModelSize) {
        return (int)(modelPosition * (long)totalModelSize / totalViewSize);
    }

    public synchronized void setAnnotations(List<RangeAnnotation> annotations) {
        this.annotations = annotations;
    }

    public void updateFrequencyCounts(Map<Range, Integer> binCounts, int max) {
        ArrayList<RangeAnnotation> as = new ArrayList<RangeAnnotation>();
        if (binCounts != null) {
            for (Range r : binCounts.keySet()) {
                int count = binCounts.get(r);
                Color c = this.getBlendColour(count, max);
                as.add(new RangeAnnotation((long)r.getMin(), (long)r.getMax(), c));
            }
        }
        this.setAnnotations(as);
    }

    private Color getBlendColour(int count, int max) {
        return new Color(69, 172, 237, (int)(255.0 * (double)count / (double)max));
    }

    private static Color createBlend(double val) {
        int i0 = 0;
        int i1 = 1;
        double w1 = val;
        double w0 = 1.0 - w1;
        return new Color((int)((double)HEATMAP_COLORS[i0].getRed() * w0 + (double)HEATMAP_COLORS[i1].getRed() * w1), (int)((double)HEATMAP_COLORS[i0].getGreen() * w0 + (double)HEATMAP_COLORS[i1].getGreen() * w1), (int)((double)HEATMAP_COLORS[i0].getBlue() * w0 + (double)HEATMAP_COLORS[i1].getBlue() * w1));
    }

    @Override
    public void handleEvent(VariantRecord r) {
        this.selectedVariant = r;
        this.repaint();
    }
}

