/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.ChromosomePanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class GenomeContainer
extends JLayeredPane {
    private Chromosome[] genome;
    private final JPanel chrContainer;
    private ArrayList<ChromosomePanel> chrViews;
    private WaitPanel waitPanel;
    private JPanel chrPlusButtonContainer;
    private final String pageName;
    private final Object updateLock = new Object();
    private boolean updateRequired = true;
    private boolean init = false;
    private GetNumVariantsSwingWorker gnv;

    public GenomeContainer(String pageName, Chromosome[] g) {
        this.pageName = pageName;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.chrPlusButtonContainer = new JPanel();
        this.chrPlusButtonContainer.setLayout(new BorderLayout());
        this.chrContainer = ViewUtil.getClearPanel();
        this.chrContainer.setBorder(ViewUtil.getBigBorder());
        this.chrContainer.setLayout(new BoxLayout(this.chrContainer, 0));
        this.chrPlusButtonContainer.add((Component)this.chrContainer, "Center");
        this.add(this.chrPlusButtonContainer, gbc, JLayeredPane.DEFAULT_LAYER);
        this.waitPanel = new WaitPanel("Generating Genome View");
        this.add(this.waitPanel, gbc, JLayeredPane.PALETTE_LAYER);
        this.init = true;
        this.genome = g;
        this.setChromosomeViews();
        this.updateIfRequired();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                GenomeContainer.this.updateIfRequired();
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
                if (GenomeContainer.this.gnv != null && !GenomeContainer.this.gnv.isDone()) {
                    GenomeContainer.this.gnv.cancel(true);
                }
            }
        });
    }

    private void setChromosomeViews() {
        this.chrContainer.removeAll();
        this.chrViews = new ArrayList();
        long max = Long.MIN_VALUE;
        for (Chromosome c : this.genome) {
            this.chrViews.add(new ChromosomePanel(c));
            max = Math.max(max, (long)c.getLength());
        }
        this.chrContainer.add(Box.createHorizontalGlue());
        for (ChromosomePanel cv : this.chrViews) {
            cv.setScaleWithRespectToLength(max);
            this.chrContainer.add(cv);
            this.chrContainer.add(ViewUtil.getMediumSeparator());
        }
        this.chrContainer.add(Box.createHorizontalGlue());
    }

    private synchronized void showWaitCard() {
        this.waitPanel.setVisible(true);
        this.setLayer(this.waitPanel, JLayeredPane.MODAL_LAYER);
        this.waitPanel.repaint();
    }

    private synchronized void showShowCard() {
        this.waitPanel.setVisible(false);
        this.chrPlusButtonContainer.repaint();
    }

    public void setUpdateRequired(boolean b) {
        this.updateRequired = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateIfRequired() {
        if (!this.init) {
            return;
        }
        boolean shouldUpdate = false;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.updateRequired && this.isVisible() && this.getSize().getWidth() != 0.0) {
                this.updateRequired = false;
                shouldUpdate = true;
            }
        }
        if (shouldUpdate) {
            this.showWaitCard();
            this.gnv = new GetNumVariantsSwingWorker(this.pageName);
            this.gnv.execute();
        }
    }

    private class GetNumVariantsSwingWorker
    extends MedSavantWorker {
        GetNumVariantsSwingWorker(String pageName) {
            super(pageName);
            FilterController.getInstance().addListener(new Listener<FilterEvent>(){

                @Override
                public void handleEvent(FilterEvent event) {
                    if (!GetNumVariantsSwingWorker.this.isDone()) {
                        GetNumVariantsSwingWorker.this.cancel(true);
                    }
                }
            });
        }

        protected Object doInBackground() throws InterruptedException, SQLException, RemoteException {
            try {
                long start = System.currentTimeMillis();
                Map<String, Map<Range, Integer>> map = MedSavantClient.VariantManager.getChromosomeHeatMap(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), FilterController.getInstance().getAllFilterConditions(), 3000000);
                long time = System.currentTimeMillis() - start;
                int mmax = 0;
                for (String s : map.keySet()) {
                    for (Range r : map.get(s).keySet()) {
                        int val = map.get(s).get(r);
                        mmax = val > mmax ? val : mmax;
                    }
                }
                int max = mmax;
                for (ChromosomePanel p : GenomeContainer.this.chrViews) {
                    Map<Range, Integer> m = map.get(p.getChrName());
                    if (m == null) {
                        m = map.get(p.getShortChrName());
                    }
                    p.updateFrequencyCounts(m, max);
                }
                GenomeContainer.this.showShowCard();
                return true;
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
        }

        @Override
        protected void showProgress(double fraction) {
        }

        protected void showSuccess(Object result) {
            GenomeContainer.this.showShowCard();
        }
    }
}

