/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.SplitScreenPanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.TablePanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.ComprehensiveInspector;
import org.ut.biolab.medsavant.client.view.util.PeekingPanel;
import org.ut.biolab.medsavant.client.view.util.PeekingPanelContainer;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class SpreadsheetPage
extends AppSubSection
implements Listener<FilterEvent> {
    private static final Log LOG = LogFactory.getLog(SpreadsheetPage.class);
    private Thread viewPreparationThread;
    private JPanel view;
    private JPanel outerTablePanel;
    private TablePanel tablePanel;
    private Component[] settingComponents;
    private PeekingPanel detailView;
    private ComprehensiveInspector inspectorPanel;

    @Override
    public void clearSelection() {
        if (this.tablePanel != null) {
            this.tablePanel.clearSelection();
        }
    }

    public SpreadsheetPage(MultiSectionApp parent) {
        super(parent, "Spreadsheet");
        FilterController.getInstance().addListener(new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                SpreadsheetPage.this.queueTableUpdate();
            }
        });
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    SpreadsheetPage.this.queueTableUpdate();
                }
            }
        });
        FilterController.getInstance().addListener(this);
    }

    @Override
    public Component[] getSubSectionMenuComponents() {
        if (this.settingComponents == null) {
            this.settingComponents = new Component[1];
            try {
                this.viewPreparationThread.join();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            if (this.detailView == null) {
                System.err.println("detailView is null!");
            }
            this.settingComponents[0] = PeekingPanel.getToggleButtonForPanel(this.detailView, "Inspector");
        }
        return this.settingComponents;
    }

    @Override
    public JPanel getView() {
        try {
            if (this.view == null) {
                this.view = new JPanel();
                this.view.setLayout(new BorderLayout());
                this.view.add(new WaitPanel("Preparing Spreadsheet..."));
                Runnable prepareViewInBackground = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOG.debug((Object)"Running thread prepareViewINBackground!");
                            JPanel tmpView = new JPanel();
                            tmpView.setLayout(new BorderLayout());
                            SpreadsheetPage.this.tablePanel = new TablePanel(SpreadsheetPage.this.pageName);
                            SplitScreenPanel ssp = new SplitScreenPanel(SpreadsheetPage.this.tablePanel);
                            SpreadsheetPage.this.inspectorPanel = new ComprehensiveInspector(true, true, true, true, true, true, true, true, true, ssp);
                            SpreadsheetPage.this.inspectorPanel.addSelectionListener(new Listener<Object>(){

                                @Override
                                public void handleEvent(Object event) {
                                    SpreadsheetPage.this.clearSelection();
                                }
                            });
                            TablePanel.addVariantSelectionChangedListener(new Listener<VariantRecord>(){

                                @Override
                                public void handleEvent(VariantRecord r) {
                                    SpreadsheetPage.this.inspectorPanel.setVariantRecord(r);
                                }
                            });
                            LOG.debug((Object)"Constructing detailView");
                            tmpView.add((Component)ssp, "Center");
                            final PeekingPanelContainer ppc = new PeekingPanelContainer(tmpView);
                            SpreadsheetPage.this.detailView = ppc.addPeekingPanel("Inspector", "East", SpreadsheetPage.this.inspectorPanel, false, 380);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SpreadsheetPage.this.view.removeAll();
                                    SpreadsheetPage.this.view.add((Component)ppc, "Center");
                                    SpreadsheetPage.this.view.updateUI();
                                }
                            });
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex);
                            System.out.println("Caught spreadsheet loading error: " + ex);
                            ex.printStackTrace();
                            SpreadsheetPage.this.view.removeAll();
                            WaitPanel p = new WaitPanel("Error loading Spreadsheet");
                            p.setComplete();
                            SpreadsheetPage.this.view.add(p);
                        }
                    }
                };
                this.viewPreparationThread = new Thread(prepareViewInBackground);
                this.viewPreparationThread.start();
            }
            return this.view;
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error generating genome view: %s", ex);
            return this.view;
        }
    }

    @Override
    public void viewWillLoad() {
        super.viewWillLoad();
        this.tablePanel.setTableShowing(true);
        if (this.inspectorPanel != null && this.detailView.isExpanded()) {
            this.inspectorPanel.refresh();
        }
    }

    @Override
    public void viewDidUnload() {
        super.viewDidUnload();
        this.tablePanel.setTableShowing(false);
    }

    public void queueTableUpdate() {
        ThreadController.getInstance().cancelWorkers(this.pageName);
        if (this.tablePanel == null) {
            return;
        }
        this.tablePanel.queueUpdate();
    }

    @Override
    public void handleEvent(FilterEvent event) {
        if (this.tablePanel != null) {
            this.tablePanel.clearSelection();
        }
        if (this.inspectorPanel != null) {
            this.inspectorPanel.setVariantRecord(null);
            this.inspectorPanel.setGene(null);
        }
    }
}

